/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jama;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.jama.JamaDenseDoubleMatrix2DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<Matrix> {
    private static final long serialVersionUID = -6065454603299978242L;
    public static final JamaDenseDoubleMatrix2DFactory Factory = new JamaDenseDoubleMatrix2DFactory();
    private final Matrix matrix;

    public JamaDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new Matrix(rows, columns);
    }

    public JamaDenseDoubleMatrix2D(Matrix matrix) {
        super((long)matrix.getRowDimension(), (long)matrix.getColumnDimension());
        this.matrix = matrix;
    }

    public JamaDenseDoubleMatrix2D(org.ujmp.core.Matrix source) {
        super(source.getRowCount(), source.getColumnCount());
        this.matrix = new Matrix((int)source.getRowCount(), (int)source.getColumnCount());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    public static Matrix identity(int m, int n) {
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return A;
    }

    @Override
    public org.ujmp.core.Matrix inv() {
        return new JamaDenseDoubleMatrix2D(this.matrix.inverse());
    }

    @Override
    public org.ujmp.core.Matrix invSPD() {
        CholeskyDecomposition chol = new CholeskyDecomposition(this.matrix);
        return new JamaDenseDoubleMatrix2D(chol.solve(Matrix.identity((int)this.matrix.getRowDimension(), (int)this.matrix.getRowDimension())));
    }

    @Override
    public org.ujmp.core.Matrix[] svd() {
        if (this.getColumnCount() > this.getRowCount()) {
            SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix.transpose());
            JamaDenseDoubleMatrix2D u = new JamaDenseDoubleMatrix2D(svd.getV());
            JamaDenseDoubleMatrix2D s = new JamaDenseDoubleMatrix2D(svd.getS().transpose());
            JamaDenseDoubleMatrix2D v = new JamaDenseDoubleMatrix2D(svd.getU());
            return new org.ujmp.core.Matrix[]{u, s, v};
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D u = new JamaDenseDoubleMatrix2D(svd.getU());
        JamaDenseDoubleMatrix2D s = new JamaDenseDoubleMatrix2D(svd.getS());
        JamaDenseDoubleMatrix2D v = new JamaDenseDoubleMatrix2D(svd.getV());
        return new org.ujmp.core.Matrix[]{u, s, v};
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row, column, value);
    }

    @Override
    public Matrix getWrappedObject() {
        return this.matrix;
    }

    public final org.ujmp.core.Matrix copy() {
        JamaDenseDoubleMatrix2D m = new JamaDenseDoubleMatrix2D(this.matrix.copy());
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        return new JamaDenseDoubleMatrix2D(this.matrix.transpose());
    }

    @Override
    public org.ujmp.core.Matrix[] qr() {
        if (this.getRowCount() >= this.getColumnCount()) {
            QRDecomposition qr = new QRDecomposition(this.matrix);
            JamaDenseDoubleMatrix2D q = new JamaDenseDoubleMatrix2D(qr.getQ());
            JamaDenseDoubleMatrix2D r = new JamaDenseDoubleMatrix2D(qr.getR());
            return new org.ujmp.core.Matrix[]{q, r};
        }
        throw new RuntimeException("QR decomposition only works for matrices m>=n");
    }

    @Override
    public org.ujmp.core.Matrix[] lu() {
        LUDecomposition lu = new LUDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D l = new JamaDenseDoubleMatrix2D(lu.getL());
        JamaDenseDoubleMatrix2D u = new JamaDenseDoubleMatrix2D(lu.getU());
        int m = (int)this.getRowCount();
        int[] piv = lu.getPivot();
        JamaDenseDoubleMatrix2D p = new JamaDenseDoubleMatrix2D(m, m);
        for (int i = 0; i < m; ++i) {
            p.setAsDouble(1.0, new long[]{i, piv[i]});
        }
        return new org.ujmp.core.Matrix[]{l, u, p};
    }

    @Override
    public org.ujmp.core.Matrix[] eig() {
        EigenvalueDecomposition eig = new EigenvalueDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D v = new JamaDenseDoubleMatrix2D(eig.getV());
        JamaDenseDoubleMatrix2D d = new JamaDenseDoubleMatrix2D(eig.getD());
        return new org.ujmp.core.Matrix[]{v, d};
    }

    @Override
    public org.ujmp.core.Matrix chol() {
        CholeskyDecomposition chol = new CholeskyDecomposition(this.matrix);
        JamaDenseDoubleMatrix2D r = new JamaDenseDoubleMatrix2D(chol.getL());
        return r;
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m) {
        if (m instanceof JamaDenseDoubleMatrix2D) {
            return new JamaDenseDoubleMatrix2D(this.matrix.times(((JamaDenseDoubleMatrix2D)m).matrix));
        }
        return super.mtimes(m);
    }

    @Override
    public org.ujmp.core.Matrix times(double value) {
        JamaDenseDoubleMatrix2D result = new JamaDenseDoubleMatrix2D(this.matrix.times(value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public org.ujmp.core.Matrix divide(double value) {
        JamaDenseDoubleMatrix2D result = new JamaDenseDoubleMatrix2D(this.matrix.times(1.0 / value));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public double det() {
        return this.matrix.det();
    }

    @Override
    public org.ujmp.core.Matrix plus(org.ujmp.core.Matrix m) {
        if (m instanceof JamaDenseDoubleMatrix2D) {
            JamaDenseDoubleMatrix2D result = new JamaDenseDoubleMatrix2D(this.matrix.plus(((JamaDenseDoubleMatrix2D)m).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(m);
    }

    @Override
    public org.ujmp.core.Matrix minus(org.ujmp.core.Matrix m) {
        if (m instanceof JamaDenseDoubleMatrix2D) {
            JamaDenseDoubleMatrix2D result = new JamaDenseDoubleMatrix2D(this.matrix.minus(((JamaDenseDoubleMatrix2D)m).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.minus(m);
    }

    @Override
    public org.ujmp.core.Matrix solve(org.ujmp.core.Matrix b) {
        if (b instanceof JamaDenseDoubleMatrix2D) {
            JamaDenseDoubleMatrix2D b2 = (JamaDenseDoubleMatrix2D)b;
            Matrix x = this.matrix.solve(b2.matrix);
            return new JamaDenseDoubleMatrix2D(x);
        }
        return super.solve(b);
    }

    @Override
    public org.ujmp.core.Matrix solveSPD(org.ujmp.core.Matrix b) {
        if (b instanceof JamaDenseDoubleMatrix2D) {
            JamaDenseDoubleMatrix2D b2 = (JamaDenseDoubleMatrix2D)b;
            CholeskyDecomposition chol = new CholeskyDecomposition(this.matrix);
            return new JamaDenseDoubleMatrix2D(chol.solve(b2.matrix));
        }
        return super.solve(b);
    }

    public JamaDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

