/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.ujmp.jdbc.util.SQLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCKeyIterator<K>
implements Iterator<K> {
    private final ResultSet rs;
    private final Class<?> keyClass;
    private K currentKey = null;

    public JDBCKeyIterator(ResultSet rs, Class<?> keyClass) {
        this.rs = rs;
        this.keyClass = keyClass;
        try {
            if (rs.next()) {
                this.currentKey = SQLUtil.getObject(rs, 1, keyClass);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentKey != null;
    }

    @Override
    public K next() {
        try {
            K lastKey = this.currentKey;
            this.currentKey = this.rs.next() ? SQLUtil.getObject(this.rs, 1, this.keyClass) : null;
            return lastKey;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

