/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.ujmp.core.collections.list.FastArrayList;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.io.AbstractMemoryByteBufferConcatenation;

public class MemoryByteBufferConcatenation
extends AbstractMemoryByteBufferConcatenation {
    private final boolean useDirect;
    private final int maxBufferSize;

    public MemoryByteBufferConcatenation(long length) {
        this(true, length);
    }

    public MemoryByteBufferConcatenation(boolean useDirect, long length) {
        this(useDirect, 0x800000, MemoryByteBufferConcatenation.createByteBuffers(useDirect, 0x800000L, length));
    }

    public MemoryByteBufferConcatenation(ByteBuffer ... byteBuffers) {
        this(true, 0x800000, byteBuffers);
    }

    public MemoryByteBufferConcatenation(boolean useDirect, int maxBufferSize, ByteBuffer ... byteBuffers) {
        super(byteBuffers);
        this.useDirect = useDirect;
        this.maxBufferSize = maxBufferSize;
    }

    private static final ByteBuffer[] createByteBuffers(boolean useDirect, long singleBufferSize, long length) {
        int count = MathUtil.longToInt((long)Math.ceil((double)length / (double)singleBufferSize));
        ByteBuffer[] byteBuffers = new ByteBuffer[count];
        long remaining = length;
        for (int i = 0; i < count; ++i) {
            int size = (int)Math.min(singleBufferSize, remaining);
            byteBuffers[i] = useDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
            remaining -= (long)size;
        }
        return byteBuffers;
    }

    public void insertBytes(byte[] bytes, long position) {
        throw new RuntimeException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(long bytesToAdd) {
        MemoryByteBufferConcatenation memoryByteBufferConcatenation = this;
        synchronized (memoryByteBufferConcatenation) {
            ByteBuffer newBuffer;
            int newSize;
            List<ByteBuffer> byteBufferList = Arrays.asList(this.byteBuffers);
            ByteBuffer lastBuffer = byteBufferList.remove(byteBufferList.size() - 1);
            if (lastBuffer.capacity() < this.maxBufferSize) {
                newSize = (int)Math.min((long)this.maxBufferSize, (long)lastBuffer.capacity() + bytesToAdd);
                bytesToAdd -= (long)(newSize - lastBuffer.capacity());
                newBuffer = MemoryByteBufferConcatenation.allocate(this.useDirect, newSize);
                newBuffer.put(lastBuffer);
                byteBufferList.add(newBuffer);
            }
            while (bytesToAdd > 0L) {
                newSize = (int)Math.min((long)this.maxBufferSize, bytesToAdd);
                newBuffer = MemoryByteBufferConcatenation.allocate(this.useDirect, newSize);
                byteBufferList.add(newBuffer);
                bytesToAdd -= (long)newSize;
            }
            this.byteBuffers = byteBufferList.toArray(this.byteBuffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink(long bytesToRemove) {
        MemoryByteBufferConcatenation memoryByteBufferConcatenation = this;
        synchronized (memoryByteBufferConcatenation) {
            FastArrayList<ByteBuffer> byteBufferList = new FastArrayList<ByteBuffer>(this.byteBuffers);
            while (bytesToRemove > 0L) {
                ByteBuffer lastBuffer = (ByteBuffer)byteBufferList.remove(byteBufferList.size() - 1);
                int capacity = lastBuffer.capacity();
                if ((long)capacity <= bytesToRemove) {
                    this.totalLength -= (long)capacity;
                    bytesToRemove -= (long)capacity;
                    continue;
                }
                int newSize = (int)((long)capacity - bytesToRemove);
                this.totalLength -= bytesToRemove;
                bytesToRemove = 0L;
                ByteBuffer newBuffer = MemoryByteBufferConcatenation.allocate(this.useDirect, newSize);
                lastBuffer.rewind();
                for (int i = 0; i < newSize; ++i) {
                    newBuffer.put(lastBuffer.get());
                }
                byteBufferList.add(newBuffer);
            }
            this.byteBuffers = byteBufferList.toArray(this.byteBuffers);
        }
    }

    private static final ByteBuffer allocate(boolean useDirect, int capacity) {
        if (useDirect) {
            return ByteBuffer.allocateDirect(capacity);
        }
        return ByteBuffer.allocate(capacity);
    }
}

