/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import java.util.HashSet;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.FeatureSpaceReqdParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.GeneSetScoringTableReqdParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.ModeReqdParam;
import xtools.api.param.NormModeReqdParam;
import xtools.api.param.Param;
import xtools.api.param.RandomSeedTypeParam;

public abstract class AbstractGseaTool
extends AbstractTool {
    protected GeneSetMatrixMultiChooserParam fGeneSetMatrixParam;
    protected ChipOptParam fChipParam = new ChipOptParam(false);
    protected final IntegerParam fGeneSetMinSizeParam = new IntegerParam("set_min", "Min size: exclude smaller sets", "Gene sets smaller than this number are EXLCUDED from the analysis", 15, false);
    protected final IntegerParam fGeneSetMaxSizeParam = new IntegerParam("set_max", "Max size: exclude larger sets", "Gene sets larger than this number are EXLCUDED from the analysis", 500, false);
    protected final IntegerParam fNumPermParam = new IntegerParam("nperm", "Number of permutations", "The number of permutations", 1000, new int[]{0, 1, 10, 100, 1000}, true);
    protected final RandomSeedTypeParam fRndSeedTypeParam = new RandomSeedTypeParam(this);
    protected final ModeReqdParam fCollapseModeParam;
    protected final FeatureSpaceReqdParam fFeatureSpaceParam;
    protected final BooleanParam fIncludeOnlySymbols = new BooleanParam("include_only_symbols", "Omit features with no symbol match", "If there is no known gene symbol match for a probe set omit if from the collapsed dataset", true, false);
    protected final NormModeReqdParam fNormModeParam = new NormModeReqdParam();
    protected final GeneSetScoringTableReqdParam fGcohGenReqdParam = new GeneSetScoringTableReqdParam();

    protected AbstractGseaTool(String defFeatureSpace, String defCollapseMode) {
        this.fFeatureSpaceParam = new FeatureSpaceReqdParam(defFeatureSpace);
        this.fCollapseModeParam = new ModeReqdParam("mode", "Collapsing mode for probe sets => 1 gene", "Collapsing mode for probe sets => 1 gene", defCollapseMode, new String[]{"Max_probe", "Median_of_probes", "Mean_of_probes", "Sum_of_probes", "Abs_max_of_probes"});
    }

    @Override
    public ToolCategory getCategory() {
        return ToolCategory.GSEA;
    }

    protected abstract Param[] getAdditionalParams();

    protected void doAdditionalParams() {
    }

    @Override
    public void declareParams() {
        this.fParamSet.addParamPseudoReqd(this.fChipParam);
        this.fGeneSetMatrixParam = new GeneSetMatrixMultiChooserParam(true);
        this.fParamSet.addParam(this.fGeneSetMatrixParam);
        this.fParamSet.addParam(this.fNumPermParam);
        this.fParamSet.addParamBasic(this.fGcohGenReqdParam);
        this.fParamSet.addParamBasic(this.fGeneSetMinSizeParam);
        this.fParamSet.addParamBasic(this.fGeneSetMaxSizeParam);
        this.fParamSet.addParamPseudoReqd(this.fFeatureSpaceParam);
        this.fParamSet.addParamAdv(this.fCollapseModeParam);
        this.fParamSet.addParamAdv(this.fRndSeedTypeParam);
        this.fParamSet.addParamAdv(this.fNormModeParam);
        this.fParamSet.addParamAdv(this.fIncludeOnlySymbols);
        this.doAdditionalParams();
        Param[] add = this.getAdditionalParams();
        for (int i = 0; i < add.length; ++i) {
            this.fParamSet.addParam(add[i]);
        }
    }

    protected Dataset uniquize(Dataset ds) {
        GeneSet gset = ds.getRowNamesGeneSet();
        int numRow = ds.getNumRow();
        if (gset.getNumMembers() == numRow) {
            return ds;
        }
        if (!ds.getWarnings().isEmpty()) {
            for (String warning : ds.getWarnings()) {
                this.fReport.addWarning(warning);
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("There were duplicate row identifiers in the specified dataset. One id was arbitarilly choosen. Details are below");
        buf.append("\n<br>Generally this is OK but if you want to avoid this, edit your dataset so that all row ids are unique\n<br>");
        buf.append('\n');
        buf.append("<br># of row ids in original dataset: ").append(numRow).append('\n');
        buf.append("<br># of row UNIQUE ids in original dataset: ").append(gset.getNumMembers()).append('\n');
        buf.append("<br>The duplicates were\n<br><pre>");
        HashSet<String> all = new HashSet<String>();
        HashSet<String> dup = new HashSet<String>();
        int perLine = 0;
        for (int i = 0; i < numRow; ++i) {
            String member = ds.getRowName(i);
            if (all.contains(member)) {
                if (dup.contains(member)) continue;
                buf.append(member).append('\t');
                if (perLine++ > 5) {
                    buf.append('\n');
                    perLine = 0;
                }
                dup.add(member);
                continue;
            }
            all.add(member);
        }
        buf.append("</pre>");
        this.fReport.addWarning(buf.toString());
        return new DatasetGenerators().extractRows(ds, gset);
    }

    protected RankedList uniquize(RankedList rl) {
        GeneSet gset = new GeneSet(rl.getName(), rl.getName(), rl.getRankedNames(), true);
        int size = rl.getSize();
        if (gset.getNumMembers() == size) {
            return rl;
        }
        if (!rl.getWarnings().isEmpty()) {
            for (String warning : rl.getWarnings()) {
                this.fReport.addWarning(warning);
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("There were duplicate row identifiers in the specified ranked list. One id was arbitarilly choosen. Details are below. ");
        buf.append("\n<br>Generally this is OK but if you want to avoid this, edit your ranked list so that all row ids are unique\n<br>");
        buf.append('\n');
        buf.append("<br># of row ids in original dataset: ").append(size).append('\n');
        buf.append("<br># of row UNIQUE ids in original dataset: ").append(gset.getNumMembers()).append('\n');
        buf.append("<br>The duplicates were\n<br><pre>");
        HashSet<String> all = new HashSet<String>();
        HashSet<String> dup = new HashSet<String>();
        int perLine = 0;
        for (int i = 0; i < size; ++i) {
            String member = rl.getRankName(i);
            if (all.contains(member)) {
                if (dup.contains(member)) continue;
                buf.append(member).append('\t');
                if (perLine++ > 5) {
                    buf.append('\n');
                    perLine = 0;
                }
                dup.add(member);
                continue;
            }
            all.add(member);
        }
        buf.append("</pre>");
        this.fReport.addWarning(buf.toString());
        return rl.extractRanked(gset);
    }
}

