/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.Component;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.genepattern.uiutil.UIUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaFijiTabsApplicationFrame;
import xapps.gsea.GseaWebResources;

public class UpdateChecker {
    private static final String GSEA_UPDATE_CHECK_URL = GseaWebResources.getGseaBaseURL() + "/gseaUpdate";
    private static final transient Logger klog = LoggerFactory.getLogger(UpdateChecker.class);
    private static boolean MAKE_GSEA_UPDATE_CHECK = BooleanUtils.toBoolean((String)System.getProperty("MAKE_GSEA_UPDATE_CHECK", "true")) && XPreferencesFactory.kMakeGseaUpdateCheck.getBoolean();
    private static final String UPDATE_CHECK_EXTRA_PROJECT_INFO = System.getProperty("UPDATE_CHECK_EXTRA_PROJECT_INFO", "GSEA");

    public static final void oneTimeGseaUpdateCheck(Component parent) {
        if (!XPreferencesFactory.kOnlineMode.getBoolean()) {
            klog.info("Currently running disconnected from the internet: skipping GSEA update check.");
        } else if (MAKE_GSEA_UPDATE_CHECK) {
            try {
                int currMajor = NumberUtils.toInt((String)GseaFijiTabsApplicationFrame.buildProps.getProperty("build.major", "not_found"), (int)-1);
                int currMinor = NumberUtils.toInt((String)GseaFijiTabsApplicationFrame.buildProps.getProperty("build.minor", "not_found"), (int)-1);
                int currPatch = NumberUtils.toInt((String)GseaFijiTabsApplicationFrame.buildProps.getProperty("build.patchLevel", "not_found"), (int)-1);
                String currVersion = GseaFijiTabsApplicationFrame.buildProps.getProperty("build.version", "not_found");
                if (currMajor < 0 || currMinor < 0 || currPatch < 0 || StringUtils.equals((CharSequence)currVersion, (CharSequence)"not_found")) {
                    klog.debug("Current version not recognized; skipping update check.");
                } else {
                    String versionQueryString = GSEA_UPDATE_CHECK_URL + "?currentVersion=" + GseaFijiTabsApplicationFrame.buildProps.getProperty("build.version", "not_available") + "&extraProjectInfo=" + UPDATE_CHECK_EXTRA_PROJECT_INFO;
                    URL url = new URL(versionQueryString);
                    URLConnection connection = url.openConnection();
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(20000);
                    String versionCheckInfo = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)null);
                    Properties latestGseaVersionProps = UpdateChecker.parseGseaVersionInfo(versionCheckInfo);
                    int latestMajor = NumberUtils.toInt((String)latestGseaVersionProps.getProperty("build.major", ""), (int)currMajor);
                    int latestMinor = NumberUtils.toInt((String)latestGseaVersionProps.getProperty("build.minor", ""), (int)currMinor);
                    int latestPatch = NumberUtils.toInt((String)latestGseaVersionProps.getProperty("build.patchLevel", ""), (int)currPatch);
                    if (UpdateChecker.newerVersionExists(currMajor, latestMajor, currMinor, latestMinor, currPatch, latestPatch)) {
                        String latestVersion = latestGseaVersionProps.getProperty("build.version", "");
                        String latestTimestamp = latestGseaVersionProps.getProperty("build.timestamp", "");
                        String updateMessage = latestGseaVersionProps.getProperty("build.updateMessage", "");
                        String message = "Your current version of GSEA is " + currVersion + ". A newer version";
                        if (StringUtils.isNotBlank((CharSequence)latestVersion)) {
                            message = message + " (" + latestVersion + ")";
                        }
                        message = message + " is available." + IOUtils.LINE_SEPARATOR + "To update, please download from " + GseaWebResources.getGseaBaseURL() + "/gsea/downloads.jsp";
                        if (StringUtils.isNotBlank((CharSequence)latestTimestamp)) {
                            message = message + IOUtils.LINE_SEPARATOR + "(build date: " + latestTimestamp + ")";
                        }
                        if (StringUtils.isNotBlank((CharSequence)updateMessage)) {
                            message = message + IOUtils.LINE_SEPARATOR + " " + updateMessage;
                        }
                        klog.info(message);
                        klog.info("Note: GenePattern users should update through GenePattern.");
                        if (parent != null) {
                            UIUtil.showMessageDialog(parent, message);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        MAKE_GSEA_UPDATE_CHECK = false;
    }

    private static final Properties parseGseaVersionInfo(String versionCheckInfo) throws ParseException {
        JSONParser jsonParser = new JSONParser();
        JSONObject jsonObj = (JSONObject)jsonParser.parse(versionCheckInfo);
        Properties currentGseaVersionProps = new Properties();
        currentGseaVersionProps.putAll((Map<?, ?>)jsonObj);
        return currentGseaVersionProps;
    }

    private static final boolean newerVersionExists(int currMajor, int latestMajor, int currMinor, int latestMinor, int currPatch, int latestPatch) {
        return latestMajor > currMajor || latestMajor == currMajor && latestMinor > currMinor || latestMajor == currMajor && latestMinor == currMinor && latestPatch > currPatch;
    }
}

