/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import edu.mit.broad.genome.swing.fields.ChangeValidatedDocument;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class GIntegerField
extends JTextField
implements GFieldPlusChooser {
    private final NumberFormat integerFormatter;

    public GIntegerField(int value, int columns) {
        this(value, columns, NumberFormat.getNumberInstance());
    }

    public GIntegerField(int value, int columns, NumberFormat format) {
        super(new ChangeValidatedDocument(format), null, columns);
        this.integerFormatter = format;
        format.setParseIntegerOnly(true);
        this.setInt(value);
    }

    public void setInt(int value) {
        super.setText(this.integerFormatter.format(value));
    }

    @Override
    public void setText(String text) {
        if (text != null && text.length() > 0) {
            int value = Integer.parseInt(text);
            super.setText(this.integerFormatter.format(value));
        } else {
            super.setText("0");
        }
    }

    @Override
    public Object getValue() {
        try {
            if (this.getText() == null) {
                return null;
            }
            return new Integer(this.getText());
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void setValue(Object obj) {
        Integer i = obj == null ? new Integer(Integer.MIN_VALUE) : (obj instanceof Float ? (Integer)obj : new Integer(obj.toString()));
        this.setText(i.toString());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

