/* resolvlink.c -- resolve a symbolic link.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <string.h>
#include <ctype.h>
#include <errno.h>
#include "ansidecl.h"
#include "symlink.h"
#include "symlink/ea.h"


#ifndef ELOOP
#define ELOOP		ENOENT
#endif

#ifndef _MAX_PATH
#define _MAX_PATH	260
#endif
#define MAX		_MAX_PATH


__inline__ int
DEFUN (isdirsep, (c),
int c)
{
  return ((c == '/') || (c == '\\'));
}


__inline__ int
DEFUN (value, (name, buffer, size),
char *name AND
char *buffer AND
size_t size)
{
  int handle, length;

  handle = ea_open (name, EA_OPEN_READ);
  if (handle == -1)
    return (0);

  length = ea_get (handle, SYMLINK_ATTR_LINK, buffer, size);

  ea_close (handle);

  return (length);
}


int
DEFUN (_resolvlink, (name, buffer, size),
const char *name AND
char *buffer AND
size_t size)
{
  char path[MAX], temp[MAX];
  int num, len, loop;

  if (!name || strlen (name) > (MAX - 1) || (!buffer && size))
    {
      errno = EINVAL;
      return (-1);
    }

  strcpy (path, name);

  for (loop = 0; loop < SYMLINK_SYS_MAX; ++loop)
    {
      num = value (path, temp, MAX - 1);
      if (num == 0)
	{
	  len = strlen (path);

	  if (len < size)
	    memcpy (buffer, path, len + 1);

	  return (len);
	}
      else if (num > 0)
	{
	  memcpy (path, temp, num);
	  path[num] = 0;
	}
      else
	{
	  errno = ENOENT;
	  return (-1);
	}
    }

  errno = ELOOP;
  return (-1);
}
