#define NOGDI
#include <windows.H>
#include <sys/rsxw32.h>
#include <sys/string.h>

#define MAX_CLASSES 20

static struct class {
    const char	*name;
    WNDPROC	fnct;
} classes[MAX_CLASSES];
static int classes_index = 0;


HWND CreateWindow(LPCSTR class, LPCSTR wndname, DWORD style, short x, short y,
		  short w, short h, HWND parent, HMENU menu, HINSTANCE hInst,
		  void far *cs)
{
    STACKWORDS(2+2+2+1+1+1+1+1+1+1+2);

    {
	/* search for callback function (registered class) */
	int i;
	for (i = 0; i < classes_index; i++)
	    if (strcmp(class,classes[i].name) == 0) {
		SV_CALL(M_LOAD_WNDFNCT, (ULONG)classes[i].fnct);
		break;
	    }
	/* or "listbox", "edit", "static", "mdiclient" etc. */
    }
    PUSH_LPSTR(class);
    PUSH_LPSTR(wndname);
    PUSH_LONG(style);
    PUSH_WORD(x);
    PUSH_WORD(y);
    PUSH_WORD(w);
    PUSH_WORD(h);
    PUSH_WORD(parent);
    PUSH_WORD(menu);
    PUSH_WORD(hInst);
    PUSH_LPSTR(cs);
    return WINCALL(41,USER);
}

ATOM WINAPI RegisterClass(const WNDCLASS FAR *class)
{
    STACKWORDS(2);
    WNDCLASS _class;

    if (classes_index >= MAX_CLASSES)
	return FALSE;

    memcpy(&_class, class, sizeof(WNDCLASS));

    /* save class and wndproc */
    classes[classes_index].name = class->lpszClassName;
    classes[classes_index].fnct = class->lpfnWndProc;
    classes_index++;

    /* change WndProc to 16bit code WndProc */
    _class.lpfnWndProc = (WNDPROC)_rsxw32_callback;

    /* convert menuname */
    if ((ULONG)_class.lpszMenuName > INT_RESOURCE)
	_class.lpszMenuName = (LPSTR)_rsx_32to16((char *)_class.lpszMenuName);

    /* convert classname */
    _class.lpszClassName = (LPCSTR) _rsx_32to16((char *)_class.lpszClassName);


    PUSH_LPSTR(&_class);
    return WINCALL(57,USER);
}

LRESULT WINAPI SendMessage(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
    STACKWORDS(1+1+1+2);
    MDICREATESTRUCT *pMDI = 0;

    /* user don't use CreateWindow for MDI childs */
    if (msg == WM_MDICREATE) {
	int i;

	if (!(pMDI = (MDICREATESTRUCT *) _rsx_16to32(lp)))
	    return 0;

	/* search for callback function */
	for (i = 0; i < classes_index; i++)
	    if (strcmp(pMDI->szClass, classes[i].name) == 0) {
		SV_CALL(M_LOAD_WNDFNCT, (ULONG)classes[i].fnct);
		break;
	    }

	/* convert title, owner */
	pMDI->szClass = (LPSTR) _rsx_32to16((char *)pMDI->szClass);
	pMDI->szTitle = (LPSTR) _rsx_32to16((char *)pMDI->szTitle);
    } /* WM_MDICREATE */

    PUSH_WORD(hWnd);
    PUSH_WORD(msg);
    PUSH_WORD(wp);
    PUSH_LONG(lp);
    return WINCALL(111,USER);
}
