/* sys/hw.h (emx+gcc) */

#if !defined (_SYS_HW_H)
#define _SYS_HW_H

#if defined (__cplusplus)
extern "C" {
#endif

void *_memaccess (unsigned first, unsigned last, int flag);
int _portaccess (unsigned first, unsigned last);

unsigned _inp8 (unsigned port);
unsigned _inp16 (unsigned port);
unsigned _inp32 (unsigned port);
void _inps8 (unsigned port, unsigned char *dst, unsigned count);
void _inps16 (unsigned port, unsigned short *dst, unsigned count);
void _inps32 (unsigned port, unsigned long *dst, unsigned count);

void _outp8 (unsigned port, unsigned value);
void _outp16 (unsigned port, unsigned value);
void _outp32 (unsigned port, unsigned value);
void _outps8 (unsigned port, __const__ unsigned char *src, unsigned count);
void _outps16 (unsigned port, __const__ unsigned short *src, unsigned count);
void _outps32 (unsigned port, __const__ unsigned long *src, unsigned count);
void _outpt (__const__ void *table);
void _outps8dac (unsigned port, __const__ unsigned char *src, unsigned count);

void _wait0 (unsigned port, unsigned mask);
void _wait1 (unsigned port, unsigned mask);
void _wait01 (unsigned port, unsigned mask);
void _wait10 (unsigned port, unsigned mask);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (SYS_HW_H) */
