void set_runtex_defaults(void)
{
/*	memset(&runtex_data,0,sizeof(runtex_data));*/
	runtex_data.keep_temps=1;
	runtex_data.exec_utils=1;
}

char* find_name_in_ini(char* buffer, const char* name)
{/* 15 letters is the most currently */
	char tmp_name[16];
	char* tmp_index;

	while (*buffer)
	{/* get first letter */
/*		while (*buffer<'a') buffer++;*/
		tmp_index=tmp_name;
		while (*buffer!='=')
		{/* read name */
			*tmp_index=*buffer;
			buffer++;
			tmp_index++;
		}
		*tmp_index=0;
		if (!strcmp(tmp_name,name))
		{/* the '=' */
			buffer++;
			return buffer;
		}
	/* not the one we search - try next line */
		while (*buffer!='\n') buffer++;
		buffer++;
	}
	return NULL;
}

int get_prefs_int(char* buffer, const char* name)
{
	char tmp_name[8];
	char* tmp_index;

	buffer=find_name_in_ini(buffer,name);
	if (!buffer) return 0;
	tmp_index=tmp_name;
	while (*buffer!='\n')
	{
		*tmp_index=*buffer;
		buffer++;
		tmp_index++;
	}
	*tmp_index=0;
	return atoi(tmp_name);
}

char* get_prefs_str(char* buffer, const char* name)
{
	char* tmp_index;
	char* tmp_name=NULL;
	int size;

	buffer=find_name_in_ini(buffer,name);
	do
	{
		if (!buffer) break;
		tmp_index=buffer;
		while (*buffer!='\n') buffer++;
		size=buffer-tmp_index;
		if (!size) break;
		new_string(tmp_name,size);
		if (!tmp_name) break;
		memcpy(tmp_name,tmp_index,size);
		*(tmp_name+size)=0;
	} while (0);
	return tmp_name;
}

char* get_prefs_path(char* buffer, const char* name)
{
	char* tmp_index;
	char* tmp_name=NULL;
	int size;
	int add_dirsep;

	buffer=find_name_in_ini(buffer,name);
	do
	{
		if (!buffer) break;
		tmp_index=buffer;
		while (*buffer!='\n') buffer++;
		size=buffer-tmp_index;
		if (!size) break;
		buffer--;
		if ((*buffer!='/') && (*buffer!='\\')) add_dirsep=1;
		else add_dirsep=0;
		new_string(tmp_name,size+add_dirsep);
		if (!tmp_name) break;
		memcpy(tmp_name,tmp_index,size);
	/* to be on the safe side */
		if (!add_dirsep) *(tmp_name+size-1)=NATIVE_DIRSEP;
		else
		{/* add the dirsep char */
			*(tmp_name+size)=NATIVE_DIRSEP;
			size++;
		}
		*(tmp_name+size)=0;
#ifdef __WIN32__
		clean_up_dirseps(tmp_name);
#endif
	} while (0);
	return tmp_name;
}

void open_text_file(char* ini_name)
{
	int length;

	runtex_data.config_file=fopen(ini_name,"rt");
	if (runtex_data.config_file)
	{
		fseek(runtex_data.config_file,0,SEEK_END);
		length=ftell(runtex_data.config_file);
		fseek(runtex_data.config_file,0,SEEK_SET);
		new_string(runtex_data.config_buffer,length);
		if (runtex_data.config_buffer)
		{
			length=fread(runtex_data.config_buffer,1,length,
				runtex_data.config_file);
			*(runtex_data.config_buffer+length)=0;
		}
		fclose(runtex_data.config_file);
		runtex_data.config_file=0;
	}
}

int set_runtex_option(char* src, char** dest, int index)
{
	if (!src) return 0;
	else
	{/* free previous value in case local .ini is being processed */
		free_if(dest[index]);
		dest[index]=src;
	}
	return 1;
}

int load_runtex_prefs(char* buffer)
{
	int i, no_error;
	char* tmp_string;
	char tmp_buffer[16];

	no_error=NUMBER_RUNTEX_INI_ENTRIES;
/* file names of tex variants */
	for(i=0; i<NUMBER_RUNTEX_TEX_VARIANTS; i++)
	{
		tmp_string=get_prefs_str(buffer,ini_names_tex[i]);
		if (!set_runtex_option(tmp_string,runtex_data.tex,i)) no_error--;
		sprintf(tmp_buffer,"%s_cmd",ini_names_tex[i]);
		tmp_string=get_prefs_str(buffer,tmp_buffer);
		if (!set_runtex_option(tmp_string,runtex_data.tex_opt,i))
			no_error--;
	}
	sprintf(tmp_buffer,"%s_type",ini_names_utils[_MAKE_INDEX]);
	i=get_prefs_int(buffer,tmp_buffer);
	if ((i<1) || (i>3))
	{/* not in .ini or not 1-3 */
		i=1;
		no_error--;
	}
	runtex_data.index_type=i;
	i=0;
/* making index command */
	if (runtex_data.index_type>1)
		tmp_string=get_prefs_path(buffer,ini_names_utils[i]);
	else tmp_string=get_prefs_str(buffer,ini_names_utils[i]);
	if (!set_runtex_option(tmp_string,runtex_data.utils,i)) no_error--;
	sprintf(tmp_buffer,"%s_cmd",ini_names_utils[i]);
	tmp_string=get_prefs_str(buffer,tmp_buffer);
	if (!set_runtex_option(tmp_string,runtex_data.utils_opt,i))
		no_error--;
	i++;
/* file names of utilities */
	for(;i<NUMBER_RUNTEX_UTILS; i++)
	{
		tmp_string=get_prefs_str(buffer,ini_names_utils[i]);
		if (!set_runtex_option(tmp_string,runtex_data.utils,i))
			no_error--;
		sprintf(tmp_buffer,"%s_cmd",ini_names_utils[i]);
		tmp_string=get_prefs_str(buffer,tmp_buffer);
		if (!set_runtex_option(tmp_string,runtex_data.utils_opt,i))
			no_error--;
	}
/* under windows _fullpath already changes all '/' to '\' so we don't need
	to use get_prefs_path() */
	tmp_string=get_prefs_path(buffer,"local_texmf");
	if (!set_runtex_option(tmp_string,&runtex_data.local_texmf,0))
		no_error--;
	tmp_string=get_prefs_path(buffer,"local_packages");
	if (!set_runtex_option(tmp_string,&runtex_data.local_packages,0))
		no_error--;
	tmp_string=get_prefs_path(buffer,"local_doc");
	if (!set_runtex_option(tmp_string,&runtex_data.local_doc,0))
		no_error--;
	free_pntr(runtex_data.config_buffer)
/* nothing read - error */
	if (!no_error) return 0;
	return 1;
}

int read_runtex_ini(char* file_name)
{
	open_text_file(file_name);
	do
	{
		if (!runtex_data.config_buffer) break;
		if (!load_runtex_prefs(runtex_data.config_buffer)) break;
		return 1;
	} while (0);
	return 0;
}
/* read the runtex.ini in the executable's dir
	read the runtex.ini in the document's dir, if available */
void read_runtex_inis(char* program_name)
{
	int ret_val;
	char* default_ini;
	char* local_ini=NULL;
	char* tmp_dir;

	default_ini=get_true_path(program_name);
	while (1)
	{/* doing it this way to avoid memory leaks */
		if (!default_ini) break;
		tmp_dir=get_dir_name(default_ini);
		if (!tmp_dir) break;
		free(default_ini);
		default_ini=create_full_file_name(tmp_dir,"runtex.ini",NULL);
		free(tmp_dir);
		if (!default_ini) break;
	/* open/read runtex.ini in program's dir */
		ret_val=read_runtex_ini(default_ini);
		if (!ret_val) break;
		if (runtex_data.print_actions)
			printf("Read default runtex.ini\n");
		local_ini=create_full_file_name(runtex_data.job_dir,"runtex.ini",NULL);
		if (!local_ini) break;
		if (!strcmp(local_ini,default_ini))
		{
			if (runtex_data.print_actions)
				printf("Default and local runtex.ini are the same\n");
		}
		else
		{
			ret_val=read_runtex_ini(local_ini);
			if (!ret_val) break;
			if (runtex_data.print_actions)
				printf("Read local runtex.ini\n");
		}
		free(local_ini);
		free(default_ini);
		return;
	}
	free_if(default_ini);
	free_if(local_ini);
	exit_on_error("Could not find/read any runtex.ini.\n");
}

