/****************************************************************************
  PROJECT: FlowerSoft C++ library
  FILE   : options.h
--*/
#ifndef __OPTIONS_H
#define __OPTIONS_H

#ifndef __OBJECT_H
#include "object.h"
#endif

#ifndef LINE_MAX
#define LINE_MAX 256
#endif

//#ifndef __GENERIC_H
//#include "generic.h"
//#endif

/****************************************************************************
  class Option
--*/

class Option : public Object 
    {  
    friend class Option_list;
                               // only for multiple inheritance solution
//    friend class Long_option_list;  
    
    const char name;
       
 public:
    static int compare_name( const Object& option, void* name )
	    {
	    return ( ( (Option&)option ).name == *(char*)name );
	    }

    virtual operator int() const = 0;

    virtual const char* argument() const;
    virtual void printOn( ostream& ) const;
    virtual const char* short_option() const;
    
    Option( const char c );
    virtual ~Option();
    };
//-- class Option //

/****************************************************************************
  class Switch_option
--*/

class Switch_option : public Option
    {
    friend class Option_list;
                               // only for multiple inheritance solution
//    friend class Long_option_list;  

    int sw_tch;
    
 public:
    virtual operator int() const;
    
    virtual void printOn( ostream& os ) const;

    Switch_option( const char name, const int s = 0 );
    virtual ~Switch_option();
    };
//-- class Switch_option //

/****************************************************************************
  class String_option
--*/

class String_option : public Option
    {
    friend class Option_list;
                               // only for multiple inheritance solution
//    friend class Long_option_list;  

    const char* string;
    
public:
    virtual operator int() const;

    virtual const char* argument() const;
    virtual void printOn( ostream& os ) const;
    virtual const char* short_option() const;

    String_option( const char name, const char* s = 0 );
//    String_option( const char name, const char** s );
    virtual ~String_option();
    };
//-- class String_option //

/****************************************************************************
  class Option_list
--*/

#ifndef __STRINGLIST_H
#include "strlist.h"
#endif

declare( List, Option );

#if 1 // __CPLUSPLUS_RELEASE__ < 21
class Option_list : public GENERIC( Option, List )
#else
class Option_list : protected GENERIC( Option, List )
#endif
    {
 protected:
    GENERIC( String, List ) non_option_list;
    GENERIC( String, ListIterator ) non_option_list_iterator;
    
 public:
    virtual operator int() const;
    virtual const char* operator ()();
    virtual const char* operator ++( POSTFIX_INT );
	 
    Option& get( const char name );
    void parse( const int argc, char* const argv[] );
    int put( Option& option );
    
    Option_list();
    virtual ~Option_list();
    };
//-- class Option_list //

extern Switch_option null_switch;

#endif // __OPTIONS_H //

