/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import com.dickimawbooks.jmakepdfx.JpdfxResources;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class ErrorPanel
extends JPanel
implements ActionListener {
    private JTextArea messageArea = this.createMessageArea();
    private JTextArea stackTraceArea = this.createMessageArea();
    private JTextArea onlyMessageArea = this.createMessageArea();
    private JTabbedPane tabbedPane;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);

    public ErrorPanel() {
        super(new BorderLayout());
        this.add((Component)this.cardPanel, "Center");
        this.cardPanel.add((Component)new JScrollPane(this.onlyMessageArea), "onlymessage");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Jmakepdfx.getLabelWithAlt("error.message", "Error Message"), new JScrollPane(this.messageArea));
        this.tabbedPane.setMnemonicAt(this.tabbedPane.getTabCount() - 1, Jmakepdfx.getMnemonic("error.message"));
        this.tabbedPane.addTab(Jmakepdfx.getLabelWithAlt("error.stacktrace", "Stack Trace"), new JScrollPane(this.stackTraceArea));
        this.tabbedPane.setMnemonicAt(this.tabbedPane.getTabCount() - 1, Jmakepdfx.getMnemonic("error.stacktrace"));
        this.cardPanel.add((Component)this.tabbedPane, "tabbedpane");
        JPanel jPanel = new JPanel();
        jPanel.add(JpdfxResources.createActionButton(Jmakepdfx.getLabel("button.copy"), Jmakepdfx.getMnemonic("button.copy"), "copy", this, KeyStroke.getKeyStroke(67, 1), Jmakepdfx.getLabel("button.copy.tooltip")));
        this.add((Component)jPanel, "East");
    }

    private JTextArea createMessageArea() {
        JTextArea jTextArea = new JTextArea(8, 30);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        return jTextArea;
    }

    public synchronized void updateMessage(String string) {
        this.updateMessage(string, null);
    }

    public synchronized void updateMessage(String string, Exception exception) {
        if (exception == null) {
            this.onlyMessageArea.setText(string);
            this.cardLayout.show(this.cardPanel, "onlymessage");
        } else {
            this.messageArea.setText(string == null ? exception.getMessage() : string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            this.stackTraceArea.setText(byteArrayOutputStream.toString());
            this.tabbedPane.setSelectedIndex(0);
            this.cardLayout.show(this.cardPanel, "tabbedpane");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("copy")) {
            int n;
            JTextArea jTextArea = this.tabbedPane.isVisible() ? ((n = this.tabbedPane.getSelectedIndex()) == 0 ? this.messageArea : this.stackTraceArea) : this.onlyMessageArea;
            jTextArea.selectAll();
            jTextArea.copy();
        }
    }
}

