{$IFDEF WINDOWS}
{$N-,B-,V-,W-,G+}
{$ELSE}
{$N-,E-,B-,V-,F+,O+}
{$ENDIF}

Unit BibGoto;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, Wobjects, Wbibgui, wbibdisp, wbibslct, wbibinit, {wbibabv,}
  wbibeden, wbibdlg, WinTypes, WinProcs, wbiblist, wbibpatt, wbibesrt,
{$ELSE}
  bibwindo, Dos, bibCrt, Objects, spawno, BibMouse, bibdisp, bibsedit,
  bibedit, bibdialg, bibselct, bibedent, biblist, bibedsrt,
{$ENDIF}
  bibstrg, streams, bibstrm, bibvars, bibfile, bibutil, bib8bit, bibtext,
  bibreadB, bibwritO, bibreach, bibfilch, bibSrtPt, bibwild,
  bibprint, bibPchec, bibsave, rc_strng, bibflch2, bibcache;

function DealWithGoto(Entry: EntryRecPtr; Pattern: PatRecPtr;
{$IFDEF WINDOWS}
                       Scroll: longint;
{$ELSE}
                       var Scroll: LongInt;
{$ENDIF}
                       FromFirst,AskForString,FirstTime: boolean;
                       selected: byte): boolean;


implementation

function DealWithGoto(Entry: EntryRecPtr; Pattern: PatRecPtr;
{$IFDEF WINDOWS}
                       Scroll: longint;
{$ELSE}
                       var Scroll: LongInt;
{$ENDIF}
                       FromFirst, AskForString,FirstTime: boolean;
                       selected: byte): boolean;
var
  line: string;
  ok,chosen,found,fchanged,retain,PatStr,accept,CaseSen,RegExp,Exact: boolean;
  UseTheIndex: boolean;
  icode,xstart: integer;
  i,j,TagLimit: longint;
  toentry,oreal2,oentry2,slen,entmax,rentmax: Word;
  Place,OPlace: longint;
  SearchPattern: PatRecPtr;
  DummyFile: text;
  Srec: SortRecType;

procedure GotoLabel(line: string; CaseSen,RegExp,Exact: boolean);
var
  ok,Abort,Matches: boolean;
begin
  if line='' then exit;
  SearchingMessage;

  if (Entry=Nil) or (Entry^.name='') then Matches:=false
  else if RegExp then
    Matches:=PartMatch(line,Entry^.Name[1],length(Entry^.Name),CaseSen)
  else if Exact then Matches:=(line=Entry^.name)
  else if CaseSen then Matches:=Pos(line,Entry^.name)>0
  else Matches:=StrPosLI(Entry^.name,line)>0;

  ReachLabel(Entry,Pattern,line,CaseSen,RegExp,Exact,ok);
  Abort:=AbortFlag;
  WaitingOff;
  if not ok then
  begin
    if not (MacroCommand or Abort) then
    begin
      if not Matches then
      begin
        if EditOnlyStrings then MessageRC(Str_StringNotFound,line)
        else MessageRC(Str_EntryNotFound,line);
      end else
      begin
        if EditOnlyStrings then MessageRC(Str_NoNewStringFound,line)
        else MessageRC(Str_NoNewEntryFound,line);
      end;
    end;
    failure:=true;
    ReachEntry(Entry,oreal2,oentry2,OPlace,false);
  end else
  begin
    scroll:=0;
    ShowNewFields(Entry);
  end;
end;                                  { GotoLabel }

begin                                      { DealWithGoto }
  Failure:=false; AbortFlag:=false; DealWithGoto:=false;
  if selected=0 then exit;
  if (CurrentBibFile=0) or (BibName^='') then Exit;
  oreal2:=entry^.realnum; oentry2:=entry^.entrynum;
  OPlace:=Entry^.beginning;
  TimeOutOn:=false;
  SearchPattern:=Nil;
  DeSuspend;
  if selected=CGoto_Next then                     { Next }
  begin
    if Pattern^.on then SearchingMessage;
    ok:=true;
    GetEntry(Entry,Nil,entry^.entrynum+1,true,Pattern,ok);
    if (not ActivePattern(Pattern)) and (entry^.realnum=1) and (Oreal2<>0) then
    begin
      ResetBib(Entry);
      GetEntry(Entry,Nil,1,true,Pattern,ok);
    end;
    WaitingOff;
    if not ok then ResetBib(Entry);
    if entry^.realnum=0 then
    begin
      if not FirstTime then
      begin
        if not MacroCommand then
        begin
          if EditOnlyStrings then messageRC(Str_NoStringFound,'')
          else MessageRC(Str_NoEntryFound,'');
        end;
        Failure:=true;
      end;
      EntryCache^.SetLast(0,Pattern);
    end else if entry^.realnum=oreal2 then
    begin
      if not FirstTime then
      begin
        if not MacroCommand then
        begin
          if EditOnlyStrings then MessageRC(Str_NoMoreStringFound,'')
          else MessageRC(Str_NoMoreEntryFound,'');
        end;
        Failure:=true;
      end;
    end else if (not WrapEOF2BOF) and (entry^.realnum<oreal2) then
    begin
      if not MacroCommand then
      begin
        if EditOnlyStrings then ErrorMessageRC(Str_PastLastString,'')
        else ErrorMessageRC(Str_PastLastEntry,'');
      end;
      Failure:=true;
      ReachEntry(Entry,oreal2,oentry2,OPlace,true);
    end else
    begin
      Scroll:=0;
{$IFDEF WINDOWS}
      UpdateWindow(HMainW);
{$ENDIF}
      ShowNewFields(Entry);
    end;
    if (Entry^.EntryNum>0) and (Entry^.EntryNum<=OEntry2) then
            EntryCache^.SetLast(OEntry2,Pattern);
  end;
  if selected=CGoto_Back then                      { Previous }
  begin
    if (not WrapEOF2BOF) and (Oentry2<=1) then
    begin
      if not MacroCommand then
      begin
        if EditOnlyStrings then ErrorMessageRC(Str_BeforeFirstString,'')
        else ErrorMessageRC(Str_BeforeFirstEntry,'');
      end;
      Failure:=true;
    end else
    begin
      if oentry2>1 then
      begin
        SearchingMessage;
        ok:=true;
{        message(num2str(OEntry2)+',last='+num2str(EntryCache^.Last));}
        GetEntry(Entry,Nil,Oentry2-1,true,Pattern,ok);
        Scroll:=0;
        if ok then ShowNewFields(Entry);
        if Entry^.EntryNum=0 then
        begin
          if not MacroCommand then
          begin
            if EditOnlyStrings then ErrorMessageRC(Str_NoStringFound,'')
            else ErrorMessageRC(Str_NoEntryFound,'');
          end;
          EntryCache^.SetLast(0,Pattern);
          failure:=true;
        end;
        WaitingOff;
      end else selected:=CGoto_Last;
    end;
  end;
  if 1=2 then message('a');
  if selected=CGoto_First then               { first }
  begin
    ResetBib(Entry);
    if Pattern^.on then SearchingMessage;;
    GetEntry(Entry,Nil,1,true,Pattern,ok);
    if ok then ShowNewFields(Entry)
    else begin
      ResetBib(Entry);
      EntryCache^.SetLast(0,Pattern);
    end;
    WaitingOff;
    Scroll:=0;
  end;
  if selected=CGoto_Last then                { Last }
  begin
    entmax:=0; rentmax:=0; 
    if EntryCache^.UseCache(Pattern) and (EntryCache^.Last>-1) then
    begin
      if EntryCache^.Last=0 then ResetBib(Entry)
      else begin
        GetEntry(Entry,Nil,EntryCache^.Last,true,Pattern,ok);
        ShowNewFields(Entry);
      end;
      Scroll:=0;
    end else
    begin
      SearchingMessage;
      ok:=true;
      if (Oreal2=0) or (suspended) then
      begin
        ResetBib(Entry);
        GetEntry(Entry,Nil,Entry^.entrynum+1,false,Pattern,ok);
      end else DeSuspend;
      while ok and (Entry^.entrynum>entmax) do
      begin
        TrapAbort;
        if AbortFlag then ok:=false
        else begin
          entmax:=Entry^.entrynum; rentmax:=Entry^.realnum;
          Place:=Entry^.beginning;
          GetEntry(Entry,Nil,Entry^.entrynum+1,false,Pattern,ok);
        end;
      end;
      WaitingOff;
      if AbortFlag then
      begin
        Failure:=true;
        ReachEntry(Entry,oreal2,oentry2,oplace,false);
      end else if entmax>0 then
      begin
        ReachEntry(Entry,rentmax,entmax,Place,true);
        Scroll:=0;
        ShowNewFields(Entry);
      end else
      begin
        if not MacroCommand then
        begin
          if EditOnlyStrings then MessageRC(Str_NoStringFound,'')
          else MessageRC(Str_NoEntryFound,'');
        end;
        Failure:=true;
        ResetBib(Entry);
      end;
    end;
    if not AbortFlag then EntryCache^.SetLast(Entry^.EntryNum,Pattern);
  end;
  if selected=CGoto_Tag then                    { Next tag }
  begin
    place:=Entry^.beginning; i:=0; j:=entry^.entrynum+1;
    DeSuspend;
    SearchingMessage;
    TagLimit:=MaxTags;
    if (not Pattern^.on) and EntryCache^.UseCache(Pattern)
      and (EntryCache^.Last>-1) then TagLimit:=EntryCache^.Last;
    if j>TagLimit then j:=1;
{    message(num2str(TagLimit)+','+num2str(j));}
    repeat
      while (i=0) and (j<=TagLimit) and (j<>Oreal2) do
      begin
        if IsTagged(j,Tags) then i:=j; inc(j);
        if (j>TagLimit) and (Oreal2>0) then j:=1;
      end;
      if i>0 then
      begin
        GetEntry(Entry,Nil,i,true,Pattern,ok);
        if not ok then i:=0
        else if Pattern^.on then
        begin
          PatternCheck(Entry,Pattern,ok,true);
          if not ok then i:=0;
        end;
      end else i:=-1;
    until (i>0) or (i=-1);
    WaitingOff;
    if i=-1 then                  { Can't find }
    begin
      if not MacroCommand then
      begin
        if (Oreal2>0) and (IsTagged(Oreal2,Tags)) then line:='another tagged '
        else line:='a tagged ';
        if EditOnlyStrings then line:=line+'string! '
        else line:=line+'entry! ';
        ErrorMessage(' Can''t find '+line);
      end;
      Failure:=true;
      ReachEntry(Entry,oreal2,oentry2,OPlace,false);
    end;
  end;
  if selected=CGoto_Bookmark then               { Bookmark }
  begin
    if Bookmark^='' then
    begin
      if not MacroCommand then ErrorMessageRC(Str_NoBookmark,'');
      Failure:=true;
    end else DeSuspend;
    GotoLabel(Bookmark^,false,false,true);
  end;
  
  if (selected=CGoto_List) or (selected=CGoto_Overview) then               { list }
  begin
    DeSuspend;
    if selected=CGoto_List then
      ShowEntryList(Entry,Pattern,chosen,found)
    else
      ShowOverview(Entry,Pattern,FromFirst,Chosen,found);
{$IFDEF WINDOWS}
    UpdateWindow(HMainW);
{$ELSE}
    if entry^.realnum<>oreal2 then Scroll:=0;
{$ENDIF}
    if chosen then ShowNewFields(Entry)
    else if not found then
    begin
      if EditOnlyStrings then messageRC(Str_NoStringFound,'')
      else messageRC(Str_NoEntryFound,'');
      Failure:=true;
    end;
  end;
  if (selected=CGoto_LabelNext) then
  begin
    if LabelSearchString^='' then selected:=CGoto_Label
    else GotoLabel(LabelSearchString^,LabelCase,LabelRegExp,false);
  end;
  if selected=CGoto_Label then                      { Label }
  begin
    CaseSen:=LabelCase; RegExp:=LabelRegExp; accept:=true; Exact:=false;
    if MacroCommand then
    begin
      CaseSen:=(ord(InputStr^[1]) and CaseSenMatch)>0;
      RegExp :=(ord(InputStr^[1]) and RegexpMatch) >0;
      Exact  :=(ord(InputStr^[1]) and ExactMatch)  >0;
      LabelSearchString^:=InputStr^; Delete(LabelSearchString^,1,1);
    end else
    if (LabelSearchString^<>'') and (LabelSearchString^[1]=#1) then   { Immediate }
    begin
      Delete(LabelSearchString^,1,1);
      if (LabelSearchString^<>'') and
        (Ord(LabelSearchString^[1])<=CaseSenMatch or RegexpMatch or ExactMatch) then
      begin
        CaseSen:=(ord(LabelSearchString^[1]) and CaseSenMatch)>0;
        RegExp :=(ord(LabelSearchString^[1]) and RegexpMatch) >0;
        Exact  :=(ord(LabelSearchString^[1]) and ExactMatch)  >0;
        Delete(LabelSearchString^,1,1);
      end;
    end else
    begin
      GetStringMode(' Goto where? ',LabelSearchString^,4,40,54,
                   NameForbid,accept,CaseSen,
                   RegExp,true);
{$IFDEF WINDOWS}
      UpdateWindow(HMainW);
{$ENDIF}
    end;
    DeSuspend;
    if accept then
    begin
      GotoLabel(LabelSearchString^,CaseSen,RegExp,Exact);
      if LabelSticky and not MacroCommand then
      begin
        LabelCase:=CaseSen; LabelRegexp:=Regexp;
      end;
    end;
  end;
  if selected=CGoto_Number then              { Number }
  begin
    line:='';
    if MacroCommand then
    begin
      line:=InputStr^;
      if Pos('-',line)+Pos('.',line)+Pos('E',line)+Pos('e',line)>0 then
        line:='';
    end else if EditOnlyStrings then
      GetAString(' Goto string number ',line,4,5,30,
               [#0..#255]-['0'..'9'],accept,false)
    else GetAString(' Goto entry number ',line,4,5,30,
               [#0..#255]-['0'..'9'],accept,false);
{$IFDEF WINDOWS}
    UpdateWindow(HMainW);
{$ENDIF}
    if line<>'' then
    begin
      Val(line,toentry,icode); ok:=false;
      if (icode=0) and (toentry<>Entry^.entrynum) and
          EntryCache^.UseCache(Pattern) and (EntryCache^.Last>-1)
          and (ToEntry>EntryCache^.Last) then
      begin
        if not MacroCommand then
        begin
          if EditOnlyStrings then MessageRC(Str_BeyondLastString,'')
          else MessageRC(Str_BeyondLastEntry,'');
        end;
        Failure:=true;
        ok:=false;
      end else if (icode=0) and (toentry<>Entry^.entrynum) then
      begin
        SearchingMessage;
        ok:=true;
        GetEntry(Entry,Nil,toentry,true,Pattern,ok);
        WaitingOff;
        if toentry<>Entry^.entrynum then
        begin
          if not MacroCommand then
          begin
            if EditOnlyStrings then ErrorMessageRC(Str_BeyondLastString,'')
            else ErrorMessageRC(Str_BeyondLastEntry,'');
          end;
          Failure:=true;
          ReachEntry(Entry,oreal2,oentry2,OPlace,false);
        end else scroll:=0;
      end;
      if toentry<>Entry^.entrynum then ok:=false;
      if ok then ShowNewFields(Entry);
    end else Failure:=true;
  end;
  if (selected=CGoto_Search) or (selected=CGoto_SearchNext) then   { search }
  begin
    retain:=true;
{$IFDEF WINDOWS}
    if MacroCommand then
    begin
      CaseSen:=(ord(InputStr^[1]) and CaseSenMatch)>0;
      RegExp :=(ord(InputStr^[1]) and RegexpMatch) >0;
      SearchString^:=InputStr^; Delete(SearchString^,1,1);
    end;
    if (selected=CGoto_SearchNext) and
       ((SearchString^='') and not UseSearchFields) then
      selected:=CGoto_Search; 
{$ELSE}
    if (selected=CGoto_SearchNext) and (SearchString^='') then
      selected:=CGoto_Search; 
{$ENDIF}
    if selected=CGoto_SearchNext then retain:=true
    else if AskForString and not MacroCommand then
    begin
      if not SearchSticky then SearchString^:='';
      line:=SearchString^;
      Slen:=length(SearchString^);
      CaseSen:=SearchCase; RegExp:=SearchRegExp;
      repeat
        retain:=false;
{$IFDEF WINDOWS}
        GetSearchString('Search for:',SearchString^,[#0..#31],
                        fchanged,retain,CaseSen,RegExp,SearchFieldStr,
                        UseSearchFields,SearchStrNegate);
        UpdateWindow(HMainW);
        Slen:=length(SearchString^);
{$ELSE}
        ReadBig('String: ',SearchString^[1],Slen,
             4,(ScrWidth-75) div 2 + 1,6,75,
             [#0..#31]-[#21],fchanged,retain,253,true,CaseSen,RegExp,
             @SearchStrNegate,true,false,'Search for:');
{$ENDIF}
        if retain and RegExp then
        begin
          SearchString^[0]:=Chr(Slen);
          Ok:=ValidRegexp(SearchString^,not MacroCommand);
          if not ok then Failure:=true
        end else ok:=true;
      until (not retain) or ok;
      if not retain then SearchString^:=line
      else begin
        if SearchSticky then
        begin
          SearchCase:=CaseSen; SearchRegExp:=RegExp;
        end;
        SearchString^[0]:=Chr(Slen);
      end;
    end;
    if Prog7bit then SConv27Bit(SearchString^,false)
    else if Prog8bit then SConv28Bit(SearchString^,false);
{$IFDEF WINDOWS}
    if retain and (UseSearchFields or (SearchString^<>'')) then
{$ELSE}
    if retain and (SearchString^<>'') then
{$ENDIF}
    begin
      SearchingMessage;
      New(SearchPattern);
      MaxMemAvail;
{$IFDEF WINDOWS}
      if UseSearchFields or (length(SearchString^)<3) then PatStr:=false
      else begin
{$ENDIF}
        InputPattern(DummyFile,Nil,SearchPattern,SearchString^,false,false);
        PatStr:=(SearchPattern^.npatt>0);
{$IFDEF WINDOWS}
      end;
{$ENDIF}
      if not PatStr then               { Not an explicit pattern }
      begin
        with SearchPattern^ do
        begin
          noper:=1; npatt:=1;
          Patrn[1]:=SearchString^;
{$IFDEF WINDOWS}
          if UseSearchFields and (SearchFieldStr<>'') then
            Field[1]:=SearchFieldStr
          else
{$ENDIF}
            Field[1]:=DefSearchScope^;
          operation[1]:=1;
          Flag[1]:=0;
          if SearchCase   then Flag[1]:=Flag[1] or PattFlag_CaseSen;
          if SearchRegExp then Flag[1]:=Flag[1] or PattFlag_Regexp;
          if SearchStrNegate then Flag[1]:=Flag[1] or PattFlag_NOT;
        end;
      end;
      SearchPattern^.on:=true;
      found:=false; i:=entry^.entrynum; if entry^.entrynum=0 then i:=0;
      ok:=true;
      DeSuspend;
      while ok and (not found) do
      begin
        j:=Entry^.entrynum+1;
        GetEntry(Entry,Nil,j,true,Pattern,ok);
        if ((not ok) or (Entry^.entrynum<>j)) and (Oentry2>1) then
        begin
          ResetBib(Entry); ok:=true;
          GetEntry(Entry,Nil,1,true,Pattern,ok);
        end;
        if ok then
        begin
          PatternCheck(Entry,SearchPattern,found,true);
          if not found then
          begin
            Inc(i);
            ok:=(i<=entry^.entrynum) or (entry^.entrynum<Oentry2);
          end;
        end;
        TrapAbort; if AbortFlag then ok:=false;
      end;
      Dispose(SearchPattern); SearchPattern:=Nil;
      WaitingOff;
      if ok then
      begin
        scroll:=0;
        ShowNewFields(Entry);
      end else
      begin
        if not (AbortFlag or MacroCommand) then MessageRC(Str_CantFindString,'');
        Failure:=true;
        ReachEntry(Entry,oreal2,oentry2,OPlace,false);
      end;
    end;
  end;
  AbortFlag:=false;
  if (not Failure) and (Entry^.RealNum<>Oreal2) then DealWithGoto:=true;
end;                                           { DealWithGoto }

end.