#!/bin/sh
# Fix a checksum line in the files given as arguments.

tmpfile=/tmp/checksum$$

for f in $*
do
  checksum=""
  newchecksum=`wc < $f | sed "s/^ *//"`
  while test "$checksum" != "$newchecksum"
  do
    sed -e "1,50s/checksum = .*,/checksum = \"$newchecksum\",/" $f > $tmpfile
    checksum="$newchecksum"
    newchecksum=`wc < $tmpfile | sed "s/^ *//"`
  done
  mv -f $tmpfile $f
done

