/* argloop.h 2.9.0 92/07/06 - read command line arguments
-----------------------------------------------------------------------
    This software module copyright (c) 1990, 1991 Damian Cugley.  
    It is provided for free on an "as-is" basis.
    See the file COPYING for more information.
    See argloop(3) for more information on this software module.
-----------------------------------------------------------------------
 */

#include "stdc.h"

typedef void (*Argloop_flag_fn) ARGS((int,int));
typedef void (*Argloop_arg_fn) ARGS((int, const char *));
typedef void (*Argloop_error_fn) ARGS((int));
typedef const char *(*Argloop_word_fn) ARGS((char *));
typedef void (*Argloop_free_fn) ARGS((char *));

typedef struct
{
  const char   *optstring;
  Argloop_flag_fn	flag;
  Argloop_arg_fn	arg;
  Argloop_error_fn	error;
} Argloop_options;

typedef struct 
{
  char	       *data;		/* pointer to data cast to char * */
  char	       *first;	 /* first arg, or NULL
			  * (for when 1st arg needs special treatment) */
  Argloop_word_fn	word;
  Argloop_free_fn	free;
} Argloop_context;

void argloop ARGS((Argloop_context *, Argloop_options *));

Argloop_context *al_argv ARGS((int argc, const char **argv));
/* 
 *  argc and argv are assumed to be as at the start of main(), i.e.,
 *  the 0th member of argv is ingored.
 */

Argloop_context *al_string ARGS((char *string));

Argloop_context *al_file ARGS((FILE *fp));

void argloop_init_files	ARGS((const char *argv0, Argloop_options *));
     
/*
 *  |argv0| is |argv[0]|, i.e., the name of the program, possibly
 *  with the directory prefix; or simply the name of the program.
 *  This reads arguments from the following files (in this order):
 *	LIB_DIR/progname.rc	(site-wide startup)
 *		(LIB_DIR is defined in ~pdc/src/include/config.h)
 *	$HOME/.prognamerc	(startup for one user)
 *	.prognamerc		(startup for one project)
 *	PROGNAMEINIT		(an environment variable, not a file)
 *
 *  And, for convenience, sets the |extern| char pointer progname
 *  to after the last `/' in |argv0|, so it can be used in messages.
 */

extern const char *progname;

extern int	argloop_debug;	/* nonzero after `-D', usually */
extern int	argloop_verbatim; /* used for progs like `env' */
