.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.09",
.\"     date            = "25 August 2001",
.\"     time            = "17:45:16 MDT",
.\"     filename        = "bibextract.man",
.\"     address         = "Center for Scientific Computing
.\"                        University of Utah
.\"                        Department of Mathematics, 322 INSCC
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     checksum        = "19236 214 948 7544",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@computer.org, beebe@ieee.org (Internet)",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "48699 195 869 6955",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@ieee.org (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, citation label,
.\"                        citation tag",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the bibextract command, a shell script
.\"                        that invokes an awk program to extract from
.\"                        a list of BibTeX .bib files bibliography
.\"                        entries that match a specified regular
.\"                        expression.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.TH BIBEXTRACT 1 "25 August 2001" "Version 1.09"
.\"======================================================================
.SH NAME
bibextract \- extract BibTeX entries from a list of .bib files
.\"======================================================================
.SH SYNOPSIS
.BI bibextract " keyword-regexp value-regexp bibfile(s)"
.\"======================================================================
.SH DESCRIPTION
.B bibextract
extracts from a list of \*(Bi\&
.I .bib
files those bibliography entries that match a pair of specified
regular expressions, sending them to
.IR stdout ,
together with all \*(Bi\& ``@Preamble{.\|.\|.}''
commands, and just those ``@String{.\|.\|.}'' commands
that are actually used by the matched entries.
.PP
If no bibliography files are specified on the
command line, then
.I stdin
is read instead, so that
.B bibextract
can be used in a UNIX pipeline.
.PP
The order of entries, and spacing
within ``@Name{.\|.\|.}'' text, is preserved
exactly.  Successive entries are separated by a
single blank line.
.PP
The first regular-expression pattern,
.IR keyword-regexp ,
is used to select which \fI``keyword =
"value"''\fP pairs to examine further; it matches
against the keyword part only.  It may include
alternate keywords separated by vertical bar, such
as "author|editor".  If it is an empty
string, then the entire bibliographic entry text,
including the entry type name, is examined.
.PP
The second regular-expression pattern,
.IR value-regexp ,
is used to further select from the value strings
of \fI``keyword = "value"''\fP pairs the
bibliography entries to be output.  It too may
contain alternates separated by vertical bar, such
as "brown|smith".  The selection algorithm
therefore consists of the logical AND of match
successes against the keyword and value strings.
.PP
Letter case is ignored in regular-expression
matches, so that "Brown|Smith", "BROWN|smith", and
"brown|smith" are equivalent.  The original letter
case of the output entries is always preserved.
.PP
If the input \*(Bi\& data comes from files named on
the command line, each output entry will contain a
final key/value pair of the form:
.nf
  bibsource =    "file://hostname/FILENAME",
.fi
The value string is a World-Wide Web Uniform
Resource Locator, where FILENAME is the full path
name of the source file in which the entry was
found.  Such lines are silently ignored by
standard \*(Bi\& styles, so they are harmless, but
they help to track the origin of bibliography
entries.
.PP
If you don't want the
.I bibsource
lines to be added, simply supply the \*(Bi\& file
from
.IR stdin .
.PP
.B bibextract
can be used to extract from a large \*(Bi\&
bibliography data base just those bibliography
entries that match a particular pair of regular
expressions.
.PP
.B bibextract
expects the bibliography file(s) to be
consistently formatted in the style produced by
.BR bibclean (1),
which allows use of simple pattern matching to
recognize the required entries.
.\"======================================================================
.SH EXAMPLES
Here are some examples:
.PP
Extract all entries mentioning chaos in any field:
.IP
.B bibextract
\&\fI"" "chaos" bibfile(s) >new-bibtex-file"\fP
.PP
Extract entries with names Brown or Smith
occurring in either of the author or editor
fields:
.IP
.B bibextract
\&\fI"author|editor" "brown|smith" bibfile(s) >new-bibtex-file\fP
.PP
Extract entries for titles containing the
letter `z' anywhere after a vowel; note that
single quotes are necessary to provide the
necessary protection from shell expansion:
.IP
.B bibextract
\&\fI"title" '[aeiou].*z' bibfile(s) >new-bibtex-file\fP
.PP
Extract all conference proceedings entries:
.IP
.B bibextract
\&\fI"" '@proceedings' bibfile(s) >new-bibtex-file\fP
.\"======================================================================
.SH BUGS
.B bibextract
is not smart enough to incorporate \*(Bi\& cross
references unless they are themselves matched by
the specified regular expression.
.PP
That feature should be added.
.\"======================================================================
.SH "SEE ALSO"
.BR bibcheck (1),
.BR bibclean (1),
.BR bibdup (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR citesub (1),
.BR citetags (1),
.BR latex (1),
.BR gawk (1),
.BR nawk (1),
.BR tex (1).
.\"======================================================================
.SH FILES
.\" NB: LIBDIR and BINDIR are substituted for real directory names
.\"     by a sed script invoked by "make install".
.TP \w'@LIBDIR@/bibextract.awk'u+2n
@LIBDIR@/bibextract.awk
.BR nawk (1)
program for tag extraction.
.TP
@BINDIR@/bibextract
user-callable shell script to invoke
.BR nawk (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Tel: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
Email: beebe@math.utah.edu, beebe@acm.org, beebe@ieee.org (Internet)
WWW: http://www.math.utah.edu/~beebe
.fi
.\"==============================[The End]==============================
