{ TEditFieldDlg methods }

type
  PInsertAbbrevDlg = ^TInsertAbbrevDlg;
  TInsertAbbrevDlg = object(TResizableDialog)
    P: PChar;
    lp: integer;
    LineHeight,Width: integer;
    ListFont: HFont;
    ExpStr,ExpIni: boolean;
    constructor init(AParent: PWindowsObject; AP: PChar; Alp: integer;
                     AStr,AIni: boolean);
    procedure   FixControlPos;                    virtual;
    procedure   wmMeasureItem(var Msg: TMessage); virtual wm_first+wm_MeasureItem;
    procedure   wmDrawItem(var Msg: TMessage);    virtual wm_First+wm_DrawItem;
    procedure   SetupWindow;                      virtual;
    procedure   HandleLBox(var Msg: TMessage);    virtual id_first+dl_InsertAbbrevLBox;
    procedure   ok(var Msg: TMessage);            virtual id_First+id_ok;
    destructor  done;                             virtual;
  end;

  PEditFieldDlg = ^TEditFieldDlg;
  TEditFieldDlg = object(TResizableDialog)
    EBox:       PEditBalanced;
    FieldList:  SelStr;
    CurrentlyEditing: integer;
    Changed,First,InitialObject,InitialHyper,InitialImage: boolean;
    ExpStrAb,ExpIniAb: boolean;
    Selection: longint;
    OldEdFont: HFont;
    BinList: PBinList;
    constructor init(AParent: PWindowsObject; AFieldList: SelStr;
                     AHyperLink: PHyperLinkObj; AObj: POleObj;
                     AExpStrAb,AExpIniAb: boolean; ABinList: PBinList);
    procedure   SetupField(n: integer);
    procedure   PutFieldBack;
    procedure   FixControlPos; virtual;
    procedure   SetupWindow;   virtual;
    procedure   wmActivate(var Msg: TMessage);virtual wm_first+wm_Activate;
    procedure   EBoxHandle(var Msg: TMessage);virtual id_first+dl_EditFieldEBox;
    procedure   BibEnterIdle(var Msg: TMessage); virtual wm_first+bib_EnterIdle;
    procedure   SaveRegs(var Msg: TMessage);  virtual id_first+dl_EditFieldSav;
    procedure   LoadRegs(var Msg: TMessage);  virtual id_first+dl_EditFieldRcl;
    procedure   HyperBtn(var Msg: TMessage);  virtual id_first+dl_EditFieldHyperBtn;
    procedure   ImageBtn(var Msg: TMessage);  virtual id_first+dl_EditFieldImage;
    procedure   ObjectBtn(var Msg: TMessage); virtual id_first+dl_EditFieldObjBtn;
    procedure   CutBtn(var Msg: TMessage);    virtual id_first+dl_EditFieldCutBtn;
    procedure   CopyBtn(var Msg: TMessage);   virtual id_first+dl_EditFieldCopyBtn;
    procedure   PasteBtn(var Msg: TMessage);  virtual id_first+dl_EditFieldPasteBtn;
    procedure   UndoBtn(var Msg: TMessage);   virtual id_first+dl_EditFieldUndoBtn;
    procedure   CapitalizeBtn(var Msg: TMessage); virtual id_first+dl_EditFieldCapBtn;
    procedure   AbbrevBtn(var Msg: TMessage); virtual id_First+dl_EditFieldAbbrev;

    procedure   Cancel(var Msg: TMessage);    virtual id_first+id_Cancel;
    procedure   Abort(var Msg: TMessage);     virtual id_first+id_abort;
    procedure   ok(var Msg: TMessage);        virtual id_first+id_ok;
    procedure   wmDestroy(var Msg: TMessage); virtual wm_First+wm_Destroy;
    destructor  done; virtual;
  end;

{ TInsertAbbrevDlg methods }

constructor TInsertAbbrevDlg.init(AParent: PWindowsObject; AP: PChar; Alp: integer;
             AStr,AIni: boolean);
begin
  TResizableDialog.init(AParent,PChar(rc_InsertAbbrevDlg),@InsertAbbrevSize);
  P:=AP; lp:=Alp; ExpStr:=AStr; ExpIni:=AIni;
  ListFont:=CreateHelvFont(true,@LineHeight);
  Width:=0;
end;

procedure TInsertAbbrevDlg.FixControlPos;
begin
  NewControl(dl_InsertAbbrevLBox,RelTo_Left, RelTo_Right,RelTo_Top,RelTo_Bottom);
  NewControl(id_Cancel,          RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_ok,              RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);
end;

procedure TInsertAbbrevDlg.wmMeasureItem(var Msg: TMessage);
begin
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    ItemWidth:=0; ItemHeight:=LineHeight;
  end;
end;

procedure TInsertAbbrevDlg.wmDrawItem(var Msg: TMessage);
begin
  DrawTabbedLBoxItem(PDrawItemStruct(Msg.lParam),ListFont,false,Width,1,false);
end;

procedure TInsertAbbrevDlg.SetupWindow;
const
  MaxLineLen = 1023;
var
  Abbrevs: TAbbrevList;
  i,j,w,ValueWidth,du: integer;
  F: PChar;
  H: HWnd;
  DC: HDC;
  OldFont: HFont;

procedure AddAbbrevs(T: TAbbrevList);
var
  i,Ind: integer;
begin
  for i:=0 to T.Count-1 do
    if not Abbrevs.Search(T.at(i),Ind) then Abbrevs.Insert(T.at(i));
end;

begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize; InitPos;
  GetMem(F,MaxLineLen+1);
  Abbrevs.init(20,20,true,false);
  if ExpStr then AddAbbrevs(StrAbbrevsList);
  if ExpIni then
  begin
    AddAbbrevs(BibAbbrevsList);
    AddAbbrevs(BstAbbrevsList);
    AddAbbrevs(IniAbbrevsList);
  end;

  Width:=0; ValueWidth:=0;
  H:=GetItemHandle(dl_EdStringsLBox);
  DC:=GetDC(H);
  OldFont:=SelectObject(DC,ListFont);
  for i:=0 to Abbrevs.Count-1 do
  with POneStringObj(Abbrevs.at(i))^ do
  begin
    w:=LoWord(GetTextExtent(DC,@SName^[1],length(SName^)));
    if w>Width then Width:=w;
    
    j:=StrLen(SValue);
    if StrLen(F)+1+j>MaxLineLen then j:=MaxLineLen-StrLen(F)-1;
    w:=LoWord(GetTextExtent(DC,SValue,j));
    if w>ValueWidth then ValueWidth:=w;

    StrPCopy(F,SName^+#9);
    StrLCat(F,SValue,MaxLineLen);
    w:=LoWord(GetTextExtent(DC,SValue,StrLen(SValue)));
    if w>ValueWidth then ValueWidth:=w;
    SendDlgItemMsg(dl_InsertAbbrevLBox,lb_AddString,0,longint(F));
  end;
  SelectObject(DC,OldFont);
  ReleaseDC(H,DC);
  du:=LoWord(GetDialogBaseUnits) div 4;
  width:=Width+8*du+TabbedLBox_XShift;
  SendDlgItemMsg(dl_InsertAbbrevLBox,lb_SetHorizontalExtent,
        Width+ValueWidth+4*du,0);
  SendDlgItemMsg(dl_InsertAbbrevLBox,lb_SetCurSel,0,0);

  Abbrevs.DeleteAll; Abbrevs.Done;
  FreeMem(F,MaxLineLen+1);
end;                     { TInsertAbbrevDlg.SetupWindow }

procedure TInsertAbbrevDlg.HandleLBox(var Msg: TMessage);
begin
  if Msg.lParamHi=lbn_DblClk then ok(Msg);
end;

procedure TInsertAbbrevDlg.ok(var Msg: TMessage);
var
  i,pl: integer;
  S: PChar;       
begin
  if not CanClose then Exit;
  i:=SendDlgItemMsg(dl_InsertAbbrevLBox,lb_GetCurSel,0,0);
  if i=lb_err then Exit;
  pl:=SendDlgItemMsg(dl_InsertAbbrevLBox,lb_GetTextLen,i,0);
  if pl=lb_err then Exit;
  GetMem(S,pl+1);
  SendDlgItemMsg(dl_InsertAbbrevLBox,lb_GetText,i,longint(S));
  P[0]:=#0; StrLCat(P,S,lp); FreeMem(S,pl+1);
  S:=StrScan(P,#9); if S<>Nil then S^:=#0;
  EndDlg(id_ok);
end;             { TInsertAbbrevDlg.ok }

destructor TInsertAbbrevDlg.Done;
begin
  if ListFont<>0 then DeleteObject(ListFont);
  TResizableDialog.Done;
end;

{ TEditFieldDlg methods }

{ Hook function }
Var
  EFghKbrdHook: HHook;
  EFKbdHookInst: TFarProc;
  EFWindowActive: boolean;
  EFWindow: PDialog;

{$F+}
function EFTrapKbHook(Code: integer; wParam: Word; lParam: longint): longint; export;
var
  Send,ScanCode: word;
  CtrlPressed,ShftPressed,AltPressed: boolean;

begin
  Send:=0;
  if (Code<0) or (Code<>HC_ACTION) or
     (lParam and (wmChar_BeingReleased or wmChar_KeyWasDown)<>0) or
     (not EFWindowActive) or AmWaiting then
       { key releases, active menu, repeats, and the like - ignore }
  else begin
    ScanCode:=LoByte(HiWord(lParam));
    CtrlPressed:=GetKeyState(vk_Control)<0;
    ShftPressed:=GetKeyState(vk_Shift)<0;
    AltPressed :=(lParam and wmChar_AltPressed)<>0;
    if CtrlPressed and ((wParam=vk_Delete) or (wParam=$58{vk_X}))
       then Send:=dl_EditFieldCutBtn                  { Cut }      
    else if CtrlPressed and ((wParam=vk_Insert) or (wParam=$43{vk_C}))
       then Send:=dl_EditFieldCopyBtn                 { Copy }      
    else if (ShftPressed and (wParam=vk_Insert)) or
            (CtrlPressed  and (wParam=$56{vk_V}))
       then Send:=dl_EditFieldPasteBtn;               { Paste }      
  end;

  if Send<>0 then { Send wm_Command accelerator msg to parent }
  begin
    PostMessage(EFWindow^.HWindow,wm_Command,Send,
                      MakeLong(EFWindow^.GetItemHandle(Send),0));
    EFTrapKbHook:=1
  end else                 { Pass it on to the previous handler }
      EFTrapKbHook:=CallNextHookEx(EFghKbrdHook,Code,wparam,lparam);
end;                           { TrapKbHook }
{$F-}

constructor TEditFieldDlg.init(AParent: PWindowsObject; AFieldList: SelStr;
                               AHyperlink: PHyperLinkObj; AObj: POleObj;
                               AExpStrAb,AExpIniAb: boolean; ABinList: PBinList);
begin
  TResizableDialog.Init(AParent,PChar(rc_EditFieldDlg2),@EdFieldSize);
  New(EBox,InitResource(@Self,dl_EditFieldEBox,MaxBig,[]));
  FieldList:=AFieldList;
  ExpStrAb:=AExpStrAb; ExpIniAb:=AExpIniAb;
  CurrentlyEditing:=0;
  Changed:=false;
  HelpContext:=hc_EditField;
  Selection:=0;
  InitialObject:=false; InitialImage:=false;
  InitialHyper:=AHyperLink<>Nil;
  BinList:=ABinList;
  EFWindowActive:=false;
  EFWindow:=@Self;

  if InitialHyper then
  begin
    Selection:=MakeLong(AHyperlink^.StartInd,AHyperlink^.EndInd-1);
    InitialObject:=false;
  end else if AObj<>Nil then
  begin
    InitialImage:=AObj^.IsGraphic;
    InitialObject:=not AObj^.IsGraphic;
    if (Selection=0) then Selection:=MakeLong(AObj^.StartInd,AObj^.EndInd);
  end;
  First:=true;
end;                     { TEditFieldDlg.init }

procedure TEditFieldDlg.EboxHandle(var Msg: TMessage);
var
  CurSelection: Longint;
begin
  if Msg.lParamHi=en_SetFocus then
  begin
    CurSelection:=SendMessage(HWnd(Msg.lParamLo),em_GetSel,0,0);
    if First or ((Selection<>-1) and (CurSelection<>Selection) and
            (LoWord(CurSelection)<>HiWord(CurSelection)))
    then
      PostMessage(HWnd(Msg.lParamLo),em_SetSel,0,Selection)
    else Selection:=CurSelection;
    First:=false;
  end else if Msg.lParamHi=en_KillFocus then
    Selection:=SendMessage(HWnd(Msg.lParamLo),em_GetSel,0,0);
{  EnableWindow(GetItemHandle(dl_EditFieldUndoBtn),EBox^.CanUndo);}
end;                        { TEditFieldDlg.EboxHandle }

procedure TEditFieldDlg.BibEnterIdle(var Msg: TMessage);
var
  CurSelection: Longint;
  IsSelected,IsClipText: boolean;
begin
  CurSelection:=SendDlgItemMsg(dl_EditFieldEBox,em_GetSel,0,0);
  IsSelected:=LoWord(CurSelection)<>HiWord(CurSelection);
  EnableWindow(GetItemHandle(dl_EditFieldCutBtn),IsSelected);
  EnableWindow(GetItemHandle(dl_EditFieldCopyBtn),IsSelected);
  IsClipText :=IsClipboardFormatAvailable(cf_Text);
  EnableWindow(GetItemHandle(dl_EditFieldPasteBtn),
                           IsClipText or IsClipObject or IsClipImage);
  EnableWindow(GetItemHandle(dl_EditFieldUndoBtn),EBox^.CanUndo);
end;                 { TEditFieldDlg.BibEnterIdle }

procedure TEditFieldDlg.FixControlPos;
begin
  NewControl(dl_EditFieldCutBtn,  RelTo_Left, RelTo_Size,RelTo_Top,   RelTo_Size);
  NewControl(dl_EditFieldCopyBtn, RelTo_Left, RelTo_Size,RelTo_Top,   RelTo_Size);
  NewControl(dl_EditFieldPasteBtn,RelTo_Left, RelTo_Size,RelTo_Top,   RelTo_Size);
  NewControl(dl_EditFieldUndoBtn, RelTo_Right,RelTo_Size,RelTo_Top,   RelTo_Size);
  NewControl(dl_EditFieldHyperBtn,RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldImage,   RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldObjBtn,  RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldSav,     RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldRcl,     RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldAbbrev,  RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(dl_EditFieldCapBtn,  RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_Abort,            RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_Cancel,           RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(id_ok,               RelTo_Right,RelTo_Size,RelTo_Bottom,RelTo_Size);

  NewControl(dl_EditFieldEBox,    RelTo_Left,RelTo_Right,RelTo_Top,RelTo_Bottom);
end;                            { TEditFieldDlg.FixControlPos }

procedure TEditFieldDlg.SetupWindow;
begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize;
  InitPos;

  with Fonts^[FieldEditFont] do
  begin
    if not Initialized then
    begin
      Font:=CreateFontIndirect(Logfont);
      Initialized:=true;
    end;
    OldEdFont:=HFont(SendMessage(EBox^.HWindow,wm_GetFont,0,0));
    SendMessage(EBox^.HWindow,wm_SetFont,Font,1);
  end;
  SetupField(1);
  Show(sw_Show);
  if InitialHyper then
    PostMessage(HWindow,wm_Command,dl_EditFieldHyperBtn,
       MakeLong(GetItemHandle(dl_EditFieldHyperBtn),0))
  else if InitialImage then
    PostMessage(HWindow,wm_Command,dl_EditFieldImage,
       MakeLong(GetItemHandle(dl_EditFieldImage),0))
  else if InitialObject then
    PostMessage(HWindow,wm_Command,dl_EditFieldObjBtn,
       MakeLong(GetItemHandle(dl_EditFieldObjBtn),0));
  EnableWindow(GetItemHandle(dl_EditFieldAbbrev),
     (ExpStrAb and (StrAbbrevsList.Count>0)) or
     (ExpIniAb and (BibAbbrevsList.Count+BstAbbrevsList.Count+
            IniAbbrevsList.Count>0)));

  { Set keyboard hook for the accelerators }
  EFKbdHookInst:=MakeProcInstance(@EFTrapKbHook,HInstance);
  EFghKbrdHook:=SetWindowsHookEx(wh_Keyboard,THookProc(EFKbdHookInst),
                               Hinstance,GetCurrentTask);
end;                            { TEditFieldDlg.SetupWindow }

procedure TEditFieldDlg.wmActivate(var Msg: TMessage);
begin
  EFWindowActive:=(Msg.wParam<>wa_InActive);
  TResizableDialog.wmActivate(Msg);
end;

procedure TEditFieldDlg.SetupField(n: integer);
var
  F: array[0..255] of char;
  ifld: integer;
  fl: text;
begin
  with entry^ do
  begin
    ifld:=Ord(FieldList[n]);
    if index[ifld]=0 then
    begin
      PutTextIntoEBox('',EBox);
    end else if BigIndex[ifld]=0 then
    begin
      if content[index[ifld]]=EmptyFieldChar then StrPCopy(F,'~')
      else StrPCopy(F,content[index[ifld]]);
      PutTextIntoEBox(F,EBox);
    end else
    begin
      Big[BigIndex[ifld]]^[Blen[BigIndex[ifld]]+1]:=#0;
      PutTextIntoEBox(PChar(Big[BigIndex[ifld]]),EBox);
    end;
    StrPCopy(F,TypeField^[ifld]);
    SetWindowText(HWindow,F);
  end;
  CurrentlyEditing:=n;
  if n<length(FieldList) then
  begin
    SetWindowText(GetItemHandle(id_ok),'&Next');
    SetWindowText(GetItemHandle(id_cancel),'S&kip');
    EnableWindow(GetItemHandle(id_Abort),true);
  end else
  begin
    SetWindowText(GetItemHandle(id_ok),'&Ok');
    SetWindowText(GetItemHandle(id_cancel),'Cance&l');
    EnableWindow(GetItemHandle(id_Abort),false);
  end;
  SetFocus(EBox^.HWindow);
end;                               { TEditFieldDlg.SetupField }

procedure TEditFieldDlg.PutFieldBack;
var
  Tlen,NewTLen: word;
  S,S1,Ftmp: PChar;
  tmp: PString;
  ii,iii,ifld,NewBuffer,ncap,CapInd,i0: word;
  nbr: integer;
begin
  if not EBox^.IsModified then Exit;
  changed:=true;
  ifld:=Ord(FieldList[CurrentlyEditing]);
  S:=MemAlloc(MaxBig+1);

{  TLen:=GetWindowText(EBox^.HWindow,S,MaxBig);}
  TLen:=EBox^.GetText(S,MaxBig);
                                { Get rid of excess spaces, etc }
  ii:=1;
  while (ii<=Tlen) do
  begin
    if (S[ii-1]=#13) and (S[ii]=#10) then
    begin
      for iii:=ii+1 to TLen do S[iii-2]:=S[iii]; changed:=true;
      TLen:=TLen-2;
    end else
    begin
      if S[ii-1] in [#0..#32] then S[ii-1]:=' ';
      if (S[ii-1]=' ') and ((ii=1) or (S[ii-2]=' ')) then
      begin
        for iii:=ii to Tlen do S[iii-1]:=S[iii];
        Dec(Tlen); changed:=true;
      end else Inc(ii);
    end;
  end;
  with entry^ do
  begin
    if Tlen=0 then       { Field is empty }
    begin
      if index[ifld]>0 then
      begin
        content[index[ifld]]:='';
        index[ifld]:=0;
        if BigIndex[ifld]>0 then
        begin
          BigFree[BigIndex[ifld]]:=true;
          Blen[BigIndex[ifld]]:=0;
          BigIndex[ifld]:=0;
        end;
      end;
    end else             { Field is not empty }
    begin
      if {RetainNullFields and} (Tlen=1) and (S[0]='~') then
      begin
        S[0]:=EmptyFieldChar;
      end else
      begin
                                 { Post-process }
        if EditOnlyStrings then
        begin
          if Prog8Bit then Conv28Bit(S^,Tlen,false)
          else if Prog7Bit then Conv27Bit(S^,Tlen,false,MaxBig);
        end else if not EditOnlyStrings then
        begin
          if Prog8Bit then Conv28Bit(S^,Tlen,FieldParams^[ifld].AuthorLike)
          else if Prog7Bit then Conv27Bit(S^,Tlen,FieldParams^[ifld].AuthorLike,MaxBig);
          { Protect unusual capitalization }
          if FieldParams^[ifld].ProtectCase or FieldParams^[ifld].ProtectCap then
            ProtectMixedCase(BigTypePtr(S),TLen,MaxBig,FieldParams^[ifld].ProtectCap); 
          { Auto-Capitalize }
          if UseAutoCap and (FieldParams^[ifld].Capitalize) then
          begin
            Capitalize(BigTypePtr(S),word(Tlen),0,1,FieldParams^[ifld].AuthorLike);
          end;
          S[Tlen]:=#0;
        end;
      end;
      S[Tlen]:=#0;
                                          { Put in place }
      if index[ifld]=0 then         { New field }
      begin
        nentry:=nentry+1;
        index[ifld]:=nentry;
        content[index[ifld]]:='';
        BigIndex[ifld]:=0;
      end;
      if Tlen<256 then content[index[ifld]]:=StrPas(S)
      else begin
        Move(S^,content[index[ifld]][1],255);
        content[index[ifld]][0]:=#255;
      end;
      NewBuffer:=FindBigFree(Entry,false);
      if (Tlen<256) or (MaxNumberBig=0) or
         ((BigIndex[ifld]=0) and (NewBuffer=0)) then
      begin                          { A string }
        if BigIndex[ifld]>0 then
        begin
          BigFree[BigIndex[ifld]]:=true;
          Blen[BigIndex[ifld]]:=0;
          BigIndex[ifld]:=0;
        end;
      end else
      begin                      { A long field }
        if BigIndex[ifld]=0 then
        begin                    { A new long field }
          BigIndex[ifld]:=NewBuffer;
          BigFree[NewBuffer]:=false;
        end;
        Move(S^,Big[BigIndex[ifld]]^,Tlen);
        Blen[BigIndex[ifld]]:=Tlen;
      end;
    end;
  end;

  FreeMem(S,MaxBig+1);
end;                              { TEditFieldDlg.PutFieldBack }

procedure TEditFieldDlg.wmDestroy(var Msg: TMessage);
begin
  SendMessage(EBox^.HWindow,wm_SetFont,OldEdFont,0);
  CleanupEntry(Entry);
  TResizableDialog.wmDestroy(Msg);
end;                        { TEditFieldDlg.wmDestroy }

procedure TEditFieldDlg.SaveRegs(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PRegistersDlg,Init(@Self,true,EBox)));
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;

procedure TEditFieldDlg.LoadRegs(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PRegistersDlg,Init(@Self,false,EBox)))=id_ok
  then Selection:=-1;
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;

procedure TEditFieldDlg.HyperBtn(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PEditHyperDlg,Init(@Self,EBox)))=id_ok then
  begin
    Selection:=-1;
    if InitialObject then ok(Msg)
    else SetFocus(GetItemHandle(dl_EditFieldEBox));
  end else
  begin
    if InitialObject then cancel(Msg)
    else SetFocus(GetItemHandle(dl_EditFieldEBox));
  end;
end;                    { TEditFieldDlg.HyperBtn }

procedure TEditFieldDlg.ImageBtn(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PEditObjectDlg,
                      Init(@Self,EBox,true,EdObj_PasteNone,BinList)))=id_ok  then
  begin
    Selection:=-1;
    if InitialObject then ok(Msg)
    else SetFocus(GetItemHandle(dl_EditFieldEBox));
  end else
  begin
    if InitialObject then cancel(Msg)
    else SetFocus(GetItemHandle(dl_EditFieldEBox));
  end;
end;                   { TEditFieldDlg.ImageBtn }

procedure TEditFieldDlg.ObjectBtn(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PEditObjectDlg,
                      Init(@Self,EBox,false,EdObj_PasteNone,BinList)))=id_ok  then
  begin
    Selection:=-1;
    if InitialObject then ok(Msg)
    else SetFocus(GetItemHandle(dl_EditFieldEBox));
  end else
  begin
    if InitialObject then cancel(Msg)
    else SetFocus(GetItemHandle(dl_EditFieldEBox));
  end;
end;                   { TEditFieldDlg.ObjectBtn }

procedure TEditFieldDlg.CutBtn(var Msg: TMessage);
begin
  EBox^.Cut;
  Selection:=-1;
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;

procedure TEditFieldDlg.CopyBtn(var Msg: TMessage);
begin
  EBox^.Copy;
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;

procedure TEditFieldDlg.PasteBtn(var Msg: TMessage);
var
  HasObj,HasLink,HasImage,HadObj,HadLink,HadImage: boolean;
  which,Ind: integer;
  cap: array[1..4] of CapStrType;
  typ: array[1..4] of integer;
  ClipForm: word;
begin
  HasLink:=IsClipboardFormatAvailable(CFObjectLink);
  HasObj :=IsClipboardFormatAvailable(CFOwnerLink) and
           IsClipboardFormatAvailable(CFNative);
  HasImage:=IsClipImage;
  if IsClipboardFormatAvailable(CF_Text) then
  begin
    EBox^.paste; Selection:=-1;
  end else if HasLink or HasObj or HasImage then
  begin
    HadObj:=HasObj; HadLink:=HasLink; HadImage:=HasImage;
    for Ind:=1 to 4 do
    begin
      Cap[Ind]:=''; typ[Ind]:=EdObj_PasteNone;
    end;
    OpenClipboard(HWindow);
    ClipForm:=EnumClipboardFormats(0);
    Ind:=1;
    while (Ind<4) and (ClipForm<>0) do
    begin
      if HasLink and (ClipForm=CFObjectLink) then
      begin
        if HadObj then Cap[Ind]:='&Linked obj.' else Cap[ind]:='&Object';
        typ[Ind]:=EdObj_PasteObjLink; HasLink:=false;
      end else if HasObj and (ClipForm=CFNative) then
      begin
        Cap[Ind]:='&Object'; typ[Ind]:=EdObj_PasteObject; HasObj:=false;
      end else if HasImage and ((ClipForm=CF_Bitmap) or (ClipForm=CF_DSPBitmap)
         or (ClipForm=CF_MetafilePict) or (ClipForm=CF_DSPMetafilePict)
         or (ClipForm=CF_DIB)) then
      begin
        Cap[Ind]:='&Image'; typ[Ind]:=EdObj_PasteImage; HasImage:=false;
      end else dec(Ind);
      inc(Ind);
      ClipForm:=EnumClipboardFormats(ClipForm);
    end;
    CloseClipboard;
    Cap[Ind]:='&Cancel';
    if Ind>2 then    { let the user select a clipboard format }
      which:=typ[AskIf4(StringRC(Str_SelectClipFormat,''),
                                    Cap[1],Cap[2],Cap[3],Cap[4])]
    else begin
      which:=EdObj_PasteNone;
      if HasLink       then which:=EdObj_PasteObjLink
      else if HasObj   then which:=EdObj_PasteObject
      else if HasImage then which:=EdObj_PasteImage;
    end;
    if (which=EdObj_PasteNone) or
         (Application^.ExecDialog(New(PEditObjectDlg,
         init(@Self,EBox,which=EdObj_PasteImage,which,BinList)))=id_ok)
                   then Selection:=-1;
  end;
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;                             { TEditFieldDlg.PasteBtn }

procedure TEditFieldDlg.UndoBtn(var Msg: TMessage);
begin
  EBox^.undo;
  Selection:=-1;
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;                             { TEditFieldDlg.UndoBtn }

procedure TEditFieldDlg.CapitalizeBtn(var Msg: TMessage);
var
  buf,TBuf,TBuf2: PChar;
  StartPos,EndPos,i,j: integer;
  l: longint;
  InSelection: boolean;
  Blen: word;
  ch: char;
begin
  l:=GetWindowTextLength(EBox^.HWindow);
  if l=0 then Exit;
  EBox^.GetSelection(StartPos, EndPos);
  if (StartPos=0) and (EndPos=l) then EndPos:=StartPos;
  InSelection:=(EndPos>StartPos);
  if not InSelection then
  begin
    GetMem(buf, MaxBig+2);
    GetWindowText(EBox^.Hwindow,buf,MaxBig);
    Blen:=StrLen(buf);
  end else
  begin
    if EndPos-StartPos>MaxBig then EndPos:=StartPos+MaxBig;
    BLen:=EndPos-StartPos;
    GetMem(buf, MaxBig+2);
    GetMem(TBuf,l+2);
    GetWindowText(EBox^.HWindow,TBuf,l+1);
    TBuf2:=TBuf+StartPos;
    Move(TBuf2^,Buf^,BLen);
    Buf[BLen]:=#0;
    FreeMem(TBuf,l+2);
  end;
  Capitalize(BigTypePtr(buf),Blen,0,1,
               FieldParams^[Ord(FieldList[CurrentlyEditing])].AuthorLike);
  buf[Blen]:=#0;
  if not InSelection then SetWindowText(EBox^.HWindow,buf+Blen);
  EBox^.Insert(buf);
  Selection:=-1;
  FreeMem(buf,MaxBig+2);
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;                             { TEditFieldDlg.CapitalizeBtn }

procedure TEditFieldDlg.AbbrevBtn(var Msg: TMessage);
const
  ConcatStr: pchar = ' # ';
  Plen = 255; FLen = PLen+8;
var
  P,F,Buf0,Buf,BufSend: PChar;
  blen,tlen,i: word;
  diff,pl1,pl2,nbr1,nbr2,StartInd,EndInd: integer;
  IsMacro,IsQuote,WithinQuote,o_k: boolean;
  Select: longint;

procedure InsStr(P: PChar; Ind: integer);
var
  i,diff: integer;
  mx: word;
begin
  diff:=StrLen(P);
  if Ind+diff>=blen then Exit;
  mx:=tlen; if mx+diff>blen then mx:=blen-diff; 
  for i:=mx-1 downto Ind do buf[i+diff]:=buf[i];
  buf[mx+diff]:=#0;
  move(P[0],Buf[Ind],diff);
end;

begin
  Select:=SendDlgItemMsg(dl_EditFieldEBox,em_GetSel,0,0);
  pl1:=LoWord(Select); pl2:=HiWord(Select);
  tlen:=GetWindowTextLength(GetItemHandle(dl_EditFieldEBox));
  IsMacro:=false; IsQuote:=true;
  blen:=tlen+PLen+11;
  GetMem(Buf0,blen+1); Buf:=Buf0;

  StrPCopy(Buf0,'@"'); Buf:=Buf0+StrLen(Buf0);
  GetDlgItemText(HWindow,dl_EditFieldEBox,Buf,blen-3);

  if pl2>pl1 then   { Erase selection }
  begin
    diff:=pl2-pl1;
    for i:=pl1 to tlen-diff do Buf[i]:=Buf[i+diff];
    tlen:=tlen-(pl2-pl1);
  end;
  if (tlen>0) and (Buf[0]='@') then  { Check Macro }
  begin
    IsMacro:=true; BufSend:=Buf;
  end else
  begin
    if pl1=0 then
    begin
      Buf0[1]:='@'; BufSend:=Buf0+1;
    end else BufSend:=Buf0;
  end;
  IsQuote:=(StrScan(Buf,'"')=Nil); o_k:=true;

  if IsMacro then
  begin
    if pl1=0 then o_k:=false                  { Before the @ symbol }
    else if (pl1>1) and (pl1<tlen) then
    begin
      { Check quote level & balancing }
      nbr1:=0;
      for i:=1 to pl1-1 do
      begin
        if (nbr1=0) and (Buf[i] in [lbrace,'"']) then
        begin
          WithinQuote:=Buf[i]='"'; inc(nbr1);
          StartInd:=i;
        end else if Buf[i]=lbrace then inc(nbr1)
        else if ((nbr1=1) and (Buf[i]='"')) or (Buf[i]=rbrace) then dec(nbr1);
      end;
      if nbr1>1 then o_k:=false { Too deeply nested braces }
      else begin
        nbr2:=0;
        for i:=tlen downto pl1 do
        begin
          if (nbr2=0) and (Buf[i] in [rbrace,'"']) then
          begin
            inc(nbr2); EndInd:=i;
          end else if Buf[i]=rbrace then inc(nbr2)
          else if ((nbr2=1) and (Buf[i]='"')) or (Buf[i]=lbrace) then dec(nbr2);
        end;
        if (nbr1<>nbr2) then o_k:=false;   { unbalanced }
      end;
    end;
  end else
  begin
    nbr1:=0;
    if pl1>0 then
    for i:=0 to pl1-1 do
    begin
      if Buf[i]=lbrace then inc(nbr1)
      else if Buf[i]=rbrace then dec(nbr1);
    end;
    if nbr1>0 then o_k:=false; { Too deeply nested braces }
  end;

  if not o_k then ErrorMessageRC(Str_NoAbbrevHere,'')
  else begin
    GetMem(P,Plen+1); GetMem(F,Flen+1);
    if Application^.ExecDialog(New(PInsertAbbrevDlg,
           init(@Self,P,Plen,ExpStrAb,ExpIniAb)))=id_ok then
    begin
      if IsMacro then
      begin
        if pl1=1 then { At the beginning }
        begin
          StrCopy(F,P); StrCat(F,ConcatStr); InsStr(F,1);
        end else if pl1=tlen then { at the end }
        begin
          StrLCat(Buf,ConcatStr,blen); StrLCat(Buf,P,blen);
        end else           { In the middle of something }
        begin
          if nbr1=1 then    { Internal }
          begin
            { check for quotes }
            if Buf[StartInd]='"' then StrPCopy(F,'"')
            else StrPCopy(F,rbrace);
            StrCat(F,ConcatStr); StrLCat(F,P,FLen); StrLCat(F,ConcatStr,FLen);
            if Buf[EndInd]='"' then StrLCat(F,'"',FLen)
            else StrLCat(F,lbrace,FLen);
            InsStr(F,pl1);
          end else if nbr1=0 then  { External }
          begin
            StrCopy(F,ConcatStr); StrLCat(F,P,FLen); StrLCat(F,ConcatStr,FLen);
            InsStr(F,1);
          end;
        end;
      end else
      begin
        F[0]:=#0;
        if (tlen>0) and (pl1>0) then
        begin
          if IsQuote then StrPCopy(F,'"'+StrPas(ConcatStr))
          else begin
            Buf0[1]:=lbrace; StrPCopy(F,rbrace+StrPas(ConcatStr));
          end;
        end;
        StrLCat(F,P,FLen);
        if pl1<tlen then
        begin
          StrLCat(F,ConcatStr,FLen);
          if IsQuote then StrLCat(F,'"',FLen) else StrLCat(F,lbrace,FLen);
          if (pl1>0) and (Buf[pl1-1]=' ') then StrLCat(F,' ',FLen);
          InsStr(F,pl1);
          if IsQuote then StrLCat(Buf,'"',blen) else StrLCat(Buf,rbrace,blen);
        end else StrLCat(Buf,F,blen);
      end;
      EBox^.Clear; EBox^.Insert(BufSend);
      Selection:=-1;
    end;
    FreeMem(F,Flen+1); FreeMem(P,PLen);
  end;
  FreeMem(Buf0,blen+1);
  SetFocus(GetItemHandle(dl_EditFieldEBox));
end;                   { TEditFieldDlg.AbbrevBtn }

procedure TEditFieldDlg.Cancel(var Msg: TMessage);
begin
  if CurrentlyEditing=length(FieldList) then
  begin
    if changed then EndDlg(id_cancel+ChangedFlag)
    else EndDlg(id_cancel);
  end else SetupField(CurrentlyEditing+1);
end;

procedure TEditFieldDlg.Abort(var Msg: TMessage);
begin
  if changed then EndDlg(id_cancel+ChangedFlag)
  else EndDlg(id_cancel);
end;

procedure TEditFieldDlg.ok(var Msg: TMessage);
begin
  if CanClose then
  begin
    PutFieldBack;
    if CurrentlyEditing=length(FieldList) then
    begin
      if changed then EndDlg(id_ok+ChangedFlag)
      else EndDlg(id_ok);
    end else SetupField(CurrentlyEditing+1);
  end;
end;         { TEditFieldDlg.ok }

destructor TEditFieldDlg.Done;
begin
  UnhookWindowsHookEx(EFghKbrdHook);
  FreeProcInstance(EFKbdHookInst);
  TResizableDialog.Done;
end;

